/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.LoadBalancerFrontendIpConfigurationProperties;
import java.io.IOException;

public final class LoadBalancerFrontendIpConfiguration
implements JsonSerializable<LoadBalancerFrontendIpConfiguration> {
    private String name;
    private LoadBalancerFrontendIpConfigurationProperties properties;
    private static final ClientLogger LOGGER = new ClientLogger(LoadBalancerFrontendIpConfiguration.class);

    public String name() {
        return this.name;
    }

    public LoadBalancerFrontendIpConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    public LoadBalancerFrontendIpConfigurationProperties properties() {
        return this.properties;
    }

    public LoadBalancerFrontendIpConfiguration withProperties(LoadBalancerFrontendIpConfigurationProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model LoadBalancerFrontendIpConfiguration"));
        }
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model LoadBalancerFrontendIpConfiguration"));
        }
        this.properties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static LoadBalancerFrontendIpConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (LoadBalancerFrontendIpConfiguration)jsonReader.readObject(reader -> {
            LoadBalancerFrontendIpConfiguration deserializedLoadBalancerFrontendIpConfiguration = new LoadBalancerFrontendIpConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedLoadBalancerFrontendIpConfiguration.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedLoadBalancerFrontendIpConfiguration.properties = LoadBalancerFrontendIpConfigurationProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLoadBalancerFrontendIpConfiguration;
        });
    }
}

