/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.GalleryScriptInner;
import java.io.IOException;
import java.util.List;

public final class GalleryScriptList
implements JsonSerializable<GalleryScriptList> {
    private List<GalleryScriptInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(GalleryScriptList.class);

    public List<GalleryScriptInner> value() {
        return this.value;
    }

    public GalleryScriptList withValue(List<GalleryScriptInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public GalleryScriptList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model GalleryScriptList"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static GalleryScriptList fromJson(JsonReader jsonReader) throws IOException {
        return (GalleryScriptList)jsonReader.readObject(reader -> {
            GalleryScriptList deserializedGalleryScriptList = new GalleryScriptList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedGalleryScriptList.value = value = reader.readArray(reader1 -> GalleryScriptInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedGalleryScriptList.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryScriptList;
        });
    }
}

