/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.compute.fluent.GalleryScriptsClient;
import com.azure.resourcemanager.compute.fluent.models.GalleryScriptInner;
import com.azure.resourcemanager.compute.implementation.ComputeManagementClientImpl;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.GalleryScriptList;
import com.azure.resourcemanager.compute.models.GalleryScriptUpdate;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class GalleryScriptsClientImpl
implements GalleryScriptsClient {
    private final GalleryScriptsService service;
    private final ComputeManagementClientImpl client;

    GalleryScriptsClientImpl(ComputeManagementClientImpl client) {
        this.service = (GalleryScriptsService)RestProxy.create(GalleryScriptsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryScriptInner>> listByGallerySinglePageAsync(String resourceGroupName, String galleryName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        String apiVersion = "2025-03-03";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByGallery(this.client.getEndpoint(), "2025-03-03", this.client.getSubscriptionId(), resourceGroupName, galleryName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GalleryScriptList)res.getValue()).value(), ((GalleryScriptList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryScriptInner>> listByGallerySinglePageAsync(String resourceGroupName, String galleryName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        String apiVersion = "2025-03-03";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByGallery(this.client.getEndpoint(), "2025-03-03", this.client.getSubscriptionId(), resourceGroupName, galleryName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GalleryScriptList)res.getValue()).value(), ((GalleryScriptList)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<GalleryScriptInner> listByGalleryAsync(String resourceGroupName, String galleryName) {
        return new PagedFlux(() -> this.listByGallerySinglePageAsync(resourceGroupName, galleryName), nextLink -> this.listByGalleryNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<GalleryScriptInner> listByGalleryAsync(String resourceGroupName, String galleryName, Context context) {
        return new PagedFlux(() -> this.listByGallerySinglePageAsync(resourceGroupName, galleryName, context), nextLink -> this.listByGalleryNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<GalleryScriptInner> listByGallery(String resourceGroupName, String galleryName) {
        return new PagedIterable(this.listByGalleryAsync(resourceGroupName, galleryName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<GalleryScriptInner> listByGallery(String resourceGroupName, String galleryName, Context context) {
        return new PagedIterable(this.listByGalleryAsync(resourceGroupName, galleryName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<GalleryScriptInner>> getWithResponseAsync(String resourceGroupName, String galleryName, String galleryScriptName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryScriptName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScriptName is required and cannot be null."));
        }
        String apiVersion = "2025-03-03";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2025-03-03", this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryScriptName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GalleryScriptInner>> getWithResponseAsync(String resourceGroupName, String galleryName, String galleryScriptName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryScriptName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScriptName is required and cannot be null."));
        }
        String apiVersion = "2025-03-03";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2025-03-03", this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryScriptName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<GalleryScriptInner> getAsync(String resourceGroupName, String galleryName, String galleryScriptName) {
        return this.getWithResponseAsync(resourceGroupName, galleryName, galleryScriptName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((GalleryScriptInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<GalleryScriptInner> getWithResponse(String resourceGroupName, String galleryName, String galleryScriptName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, galleryName, galleryScriptName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GalleryScriptInner get(String resourceGroupName, String galleryName, String galleryScriptName) {
        return (GalleryScriptInner)((Object)this.getWithResponse(resourceGroupName, galleryName, galleryScriptName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String galleryName, String galleryScriptName, GalleryScriptInner galleryScript) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryScriptName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScriptName is required and cannot be null."));
        }
        if (galleryScript == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScript is required and cannot be null."));
        }
        galleryScript.validate();
        String apiVersion = "2025-03-03";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), "2025-03-03", this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryScriptName, galleryScript, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String galleryName, String galleryScriptName, GalleryScriptInner galleryScript, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryScriptName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScriptName is required and cannot be null."));
        }
        if (galleryScript == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScript is required and cannot be null."));
        }
        galleryScript.validate();
        String apiVersion = "2025-03-03";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), "2025-03-03", this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryScriptName, galleryScript, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<GalleryScriptInner>, GalleryScriptInner> beginCreateOrUpdateAsync(String resourceGroupName, String galleryName, String galleryScriptName, GalleryScriptInner galleryScript) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, galleryName, galleryScriptName, galleryScript);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)GalleryScriptInner.class), (Type)((Object)GalleryScriptInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<GalleryScriptInner>, GalleryScriptInner> beginCreateOrUpdateAsync(String resourceGroupName, String galleryName, String galleryScriptName, GalleryScriptInner galleryScript, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, galleryName, galleryScriptName, galleryScript, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)GalleryScriptInner.class), (Type)((Object)GalleryScriptInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GalleryScriptInner>, GalleryScriptInner> beginCreateOrUpdate(String resourceGroupName, String galleryName, String galleryScriptName, GalleryScriptInner galleryScript) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScript).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GalleryScriptInner>, GalleryScriptInner> beginCreateOrUpdate(String resourceGroupName, String galleryName, String galleryScriptName, GalleryScriptInner galleryScript, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScript, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<GalleryScriptInner> createOrUpdateAsync(String resourceGroupName, String galleryName, String galleryScriptName, GalleryScriptInner galleryScript) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScript).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GalleryScriptInner> createOrUpdateAsync(String resourceGroupName, String galleryName, String galleryScriptName, GalleryScriptInner galleryScript, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScript, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GalleryScriptInner createOrUpdate(String resourceGroupName, String galleryName, String galleryScriptName, GalleryScriptInner galleryScript) {
        return (GalleryScriptInner)((Object)this.createOrUpdateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScript).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GalleryScriptInner createOrUpdate(String resourceGroupName, String galleryName, String galleryScriptName, GalleryScriptInner galleryScript, Context context) {
        return (GalleryScriptInner)((Object)this.createOrUpdateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScript, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String galleryName, String galleryScriptName, GalleryScriptUpdate galleryScript) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryScriptName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScriptName is required and cannot be null."));
        }
        if (galleryScript == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScript is required and cannot be null."));
        }
        galleryScript.validate();
        String apiVersion = "2025-03-03";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), "2025-03-03", this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryScriptName, galleryScript, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String galleryName, String galleryScriptName, GalleryScriptUpdate galleryScript, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryScriptName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScriptName is required and cannot be null."));
        }
        if (galleryScript == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScript is required and cannot be null."));
        }
        galleryScript.validate();
        String apiVersion = "2025-03-03";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), "2025-03-03", this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryScriptName, galleryScript, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<GalleryScriptInner>, GalleryScriptInner> beginUpdateAsync(String resourceGroupName, String galleryName, String galleryScriptName, GalleryScriptUpdate galleryScript) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, galleryName, galleryScriptName, galleryScript);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)GalleryScriptInner.class), (Type)((Object)GalleryScriptInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<GalleryScriptInner>, GalleryScriptInner> beginUpdateAsync(String resourceGroupName, String galleryName, String galleryScriptName, GalleryScriptUpdate galleryScript, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, galleryName, galleryScriptName, galleryScript, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)GalleryScriptInner.class), (Type)((Object)GalleryScriptInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GalleryScriptInner>, GalleryScriptInner> beginUpdate(String resourceGroupName, String galleryName, String galleryScriptName, GalleryScriptUpdate galleryScript) {
        return this.beginUpdateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScript).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GalleryScriptInner>, GalleryScriptInner> beginUpdate(String resourceGroupName, String galleryName, String galleryScriptName, GalleryScriptUpdate galleryScript, Context context) {
        return this.beginUpdateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScript, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<GalleryScriptInner> updateAsync(String resourceGroupName, String galleryName, String galleryScriptName, GalleryScriptUpdate galleryScript) {
        return this.beginUpdateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScript).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GalleryScriptInner> updateAsync(String resourceGroupName, String galleryName, String galleryScriptName, GalleryScriptUpdate galleryScript, Context context) {
        return this.beginUpdateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScript, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GalleryScriptInner update(String resourceGroupName, String galleryName, String galleryScriptName, GalleryScriptUpdate galleryScript) {
        return (GalleryScriptInner)((Object)this.updateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScript).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GalleryScriptInner update(String resourceGroupName, String galleryName, String galleryScriptName, GalleryScriptUpdate galleryScript, Context context) {
        return (GalleryScriptInner)((Object)this.updateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScript, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String galleryName, String galleryScriptName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryScriptName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScriptName is required and cannot be null."));
        }
        String apiVersion = "2025-03-03";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), "2025-03-03", this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryScriptName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String galleryName, String galleryScriptName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryScriptName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScriptName is required and cannot be null."));
        }
        String apiVersion = "2025-03-03";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), "2025-03-03", this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryScriptName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String galleryName, String galleryScriptName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, galleryName, galleryScriptName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String galleryName, String galleryScriptName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, galleryName, galleryScriptName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String galleryName, String galleryScriptName) {
        return this.beginDeleteAsync(resourceGroupName, galleryName, galleryScriptName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String galleryName, String galleryScriptName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, galleryName, galleryScriptName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String galleryName, String galleryScriptName) {
        return this.beginDeleteAsync(resourceGroupName, galleryName, galleryScriptName).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String galleryName, String galleryScriptName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, galleryName, galleryScriptName, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String galleryName, String galleryScriptName) {
        this.deleteAsync(resourceGroupName, galleryName, galleryScriptName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String galleryName, String galleryScriptName, Context context) {
        this.deleteAsync(resourceGroupName, galleryName, galleryScriptName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryScriptInner>> listByGalleryNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByGalleryNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GalleryScriptList)res.getValue()).value(), ((GalleryScriptList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryScriptInner>> listByGalleryNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByGalleryNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GalleryScriptList)res.getValue()).value(), ((GalleryScriptList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ComputeManagementClientGalleryScripts")
    public static interface GalleryScriptsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/scripts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<GalleryScriptList>> listByGallery(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="galleryName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/scripts/{galleryScriptName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<GalleryScriptInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="galleryName") String var5, @PathParam(value="galleryScriptName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/scripts/{galleryScriptName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="galleryName") String var5, @PathParam(value="galleryScriptName") String var6, @BodyParam(value="application/json") GalleryScriptInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/scripts/{galleryScriptName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="galleryName") String var5, @PathParam(value="galleryScriptName") String var6, @BodyParam(value="application/json") GalleryScriptUpdate var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/scripts/{galleryScriptName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="galleryName") String var5, @PathParam(value="galleryScriptName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<GalleryScriptList>> listByGalleryNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

