/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.compute.fluent.GalleryInVMAccessControlProfileVersionsClient;
import com.azure.resourcemanager.compute.fluent.models.GalleryInVMAccessControlProfileVersionInner;
import com.azure.resourcemanager.compute.implementation.ComputeManagementClientImpl;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.GalleryInVMAccessControlProfileVersionList;
import com.azure.resourcemanager.compute.models.GalleryInVMAccessControlProfileVersionUpdate;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class GalleryInVMAccessControlProfileVersionsClientImpl
implements GalleryInVMAccessControlProfileVersionsClient {
    private final GalleryInVMAccessControlProfileVersionsService service;
    private final ComputeManagementClientImpl client;

    GalleryInVMAccessControlProfileVersionsClientImpl(ComputeManagementClientImpl client) {
        this.service = (GalleryInVMAccessControlProfileVersionsService)RestProxy.create(GalleryInVMAccessControlProfileVersionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryInVMAccessControlProfileVersionInner>> listByGalleryInVMAccessControlProfileSinglePageAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        String apiVersion = "2025-03-03";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByGalleryInVMAccessControlProfile(this.client.getEndpoint(), "2025-03-03", this.client.getSubscriptionId(), resourceGroupName, galleryName, inVMAccessControlProfileName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GalleryInVMAccessControlProfileVersionList)res.getValue()).value(), ((GalleryInVMAccessControlProfileVersionList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryInVMAccessControlProfileVersionInner>> listByGalleryInVMAccessControlProfileSinglePageAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        String apiVersion = "2025-03-03";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByGalleryInVMAccessControlProfile(this.client.getEndpoint(), "2025-03-03", this.client.getSubscriptionId(), resourceGroupName, galleryName, inVMAccessControlProfileName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GalleryInVMAccessControlProfileVersionList)res.getValue()).value(), ((GalleryInVMAccessControlProfileVersionList)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<GalleryInVMAccessControlProfileVersionInner> listByGalleryInVMAccessControlProfileAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName) {
        return new PagedFlux(() -> this.listByGalleryInVMAccessControlProfileSinglePageAsync(resourceGroupName, galleryName, inVMAccessControlProfileName), nextLink -> this.listByGalleryInVMAccessControlProfileNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<GalleryInVMAccessControlProfileVersionInner> listByGalleryInVMAccessControlProfileAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, Context context) {
        return new PagedFlux(() -> this.listByGalleryInVMAccessControlProfileSinglePageAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, context), nextLink -> this.listByGalleryInVMAccessControlProfileNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<GalleryInVMAccessControlProfileVersionInner> listByGalleryInVMAccessControlProfile(String resourceGroupName, String galleryName, String inVMAccessControlProfileName) {
        return new PagedIterable(this.listByGalleryInVMAccessControlProfileAsync(resourceGroupName, galleryName, inVMAccessControlProfileName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<GalleryInVMAccessControlProfileVersionInner> listByGalleryInVMAccessControlProfile(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, Context context) {
        return new PagedIterable(this.listByGalleryInVMAccessControlProfileAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<GalleryInVMAccessControlProfileVersionInner>> getWithResponseAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        if (inVMAccessControlProfileVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter inVMAccessControlProfileVersionName is required and cannot be null."));
        }
        String apiVersion = "2025-03-03";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2025-03-03", this.client.getSubscriptionId(), resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GalleryInVMAccessControlProfileVersionInner>> getWithResponseAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        if (inVMAccessControlProfileVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter inVMAccessControlProfileVersionName is required and cannot be null."));
        }
        String apiVersion = "2025-03-03";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2025-03-03", this.client.getSubscriptionId(), resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<GalleryInVMAccessControlProfileVersionInner> getAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName) {
        return this.getWithResponseAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((GalleryInVMAccessControlProfileVersionInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<GalleryInVMAccessControlProfileVersionInner> getWithResponse(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GalleryInVMAccessControlProfileVersionInner get(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName) {
        return (GalleryInVMAccessControlProfileVersionInner)((Object)this.getWithResponse(resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, GalleryInVMAccessControlProfileVersionInner galleryInVMAccessControlProfileVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        if (inVMAccessControlProfileVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter inVMAccessControlProfileVersionName is required and cannot be null."));
        }
        if (galleryInVMAccessControlProfileVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryInVMAccessControlProfileVersion is required and cannot be null."));
        }
        galleryInVMAccessControlProfileVersion.validate();
        String apiVersion = "2025-03-03";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), "2025-03-03", this.client.getSubscriptionId(), resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, GalleryInVMAccessControlProfileVersionInner galleryInVMAccessControlProfileVersion, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        if (inVMAccessControlProfileVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter inVMAccessControlProfileVersionName is required and cannot be null."));
        }
        if (galleryInVMAccessControlProfileVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryInVMAccessControlProfileVersion is required and cannot be null."));
        }
        galleryInVMAccessControlProfileVersion.validate();
        String apiVersion = "2025-03-03";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), "2025-03-03", this.client.getSubscriptionId(), resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<GalleryInVMAccessControlProfileVersionInner>, GalleryInVMAccessControlProfileVersionInner> beginCreateOrUpdateAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, GalleryInVMAccessControlProfileVersionInner galleryInVMAccessControlProfileVersion) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)GalleryInVMAccessControlProfileVersionInner.class), (Type)((Object)GalleryInVMAccessControlProfileVersionInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<GalleryInVMAccessControlProfileVersionInner>, GalleryInVMAccessControlProfileVersionInner> beginCreateOrUpdateAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, GalleryInVMAccessControlProfileVersionInner galleryInVMAccessControlProfileVersion, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)GalleryInVMAccessControlProfileVersionInner.class), (Type)((Object)GalleryInVMAccessControlProfileVersionInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GalleryInVMAccessControlProfileVersionInner>, GalleryInVMAccessControlProfileVersionInner> beginCreateOrUpdate(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, GalleryInVMAccessControlProfileVersionInner galleryInVMAccessControlProfileVersion) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GalleryInVMAccessControlProfileVersionInner>, GalleryInVMAccessControlProfileVersionInner> beginCreateOrUpdate(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, GalleryInVMAccessControlProfileVersionInner galleryInVMAccessControlProfileVersion, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<GalleryInVMAccessControlProfileVersionInner> createOrUpdateAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, GalleryInVMAccessControlProfileVersionInner galleryInVMAccessControlProfileVersion) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GalleryInVMAccessControlProfileVersionInner> createOrUpdateAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, GalleryInVMAccessControlProfileVersionInner galleryInVMAccessControlProfileVersion, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GalleryInVMAccessControlProfileVersionInner createOrUpdate(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, GalleryInVMAccessControlProfileVersionInner galleryInVMAccessControlProfileVersion) {
        return (GalleryInVMAccessControlProfileVersionInner)((Object)this.createOrUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GalleryInVMAccessControlProfileVersionInner createOrUpdate(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, GalleryInVMAccessControlProfileVersionInner galleryInVMAccessControlProfileVersion, Context context) {
        return (GalleryInVMAccessControlProfileVersionInner)((Object)this.createOrUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, GalleryInVMAccessControlProfileVersionUpdate galleryInVMAccessControlProfileVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        if (inVMAccessControlProfileVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter inVMAccessControlProfileVersionName is required and cannot be null."));
        }
        if (galleryInVMAccessControlProfileVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryInVMAccessControlProfileVersion is required and cannot be null."));
        }
        galleryInVMAccessControlProfileVersion.validate();
        String apiVersion = "2025-03-03";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), "2025-03-03", this.client.getSubscriptionId(), resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, GalleryInVMAccessControlProfileVersionUpdate galleryInVMAccessControlProfileVersion, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        if (inVMAccessControlProfileVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter inVMAccessControlProfileVersionName is required and cannot be null."));
        }
        if (galleryInVMAccessControlProfileVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryInVMAccessControlProfileVersion is required and cannot be null."));
        }
        galleryInVMAccessControlProfileVersion.validate();
        String apiVersion = "2025-03-03";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), "2025-03-03", this.client.getSubscriptionId(), resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<GalleryInVMAccessControlProfileVersionInner>, GalleryInVMAccessControlProfileVersionInner> beginUpdateAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, GalleryInVMAccessControlProfileVersionUpdate galleryInVMAccessControlProfileVersion) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)GalleryInVMAccessControlProfileVersionInner.class), (Type)((Object)GalleryInVMAccessControlProfileVersionInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<GalleryInVMAccessControlProfileVersionInner>, GalleryInVMAccessControlProfileVersionInner> beginUpdateAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, GalleryInVMAccessControlProfileVersionUpdate galleryInVMAccessControlProfileVersion, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)GalleryInVMAccessControlProfileVersionInner.class), (Type)((Object)GalleryInVMAccessControlProfileVersionInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GalleryInVMAccessControlProfileVersionInner>, GalleryInVMAccessControlProfileVersionInner> beginUpdate(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, GalleryInVMAccessControlProfileVersionUpdate galleryInVMAccessControlProfileVersion) {
        return this.beginUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GalleryInVMAccessControlProfileVersionInner>, GalleryInVMAccessControlProfileVersionInner> beginUpdate(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, GalleryInVMAccessControlProfileVersionUpdate galleryInVMAccessControlProfileVersion, Context context) {
        return this.beginUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<GalleryInVMAccessControlProfileVersionInner> updateAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, GalleryInVMAccessControlProfileVersionUpdate galleryInVMAccessControlProfileVersion) {
        return this.beginUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GalleryInVMAccessControlProfileVersionInner> updateAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, GalleryInVMAccessControlProfileVersionUpdate galleryInVMAccessControlProfileVersion, Context context) {
        return this.beginUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GalleryInVMAccessControlProfileVersionInner update(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, GalleryInVMAccessControlProfileVersionUpdate galleryInVMAccessControlProfileVersion) {
        return (GalleryInVMAccessControlProfileVersionInner)((Object)this.updateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GalleryInVMAccessControlProfileVersionInner update(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, GalleryInVMAccessControlProfileVersionUpdate galleryInVMAccessControlProfileVersion, Context context) {
        return (GalleryInVMAccessControlProfileVersionInner)((Object)this.updateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, galleryInVMAccessControlProfileVersion, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        if (inVMAccessControlProfileVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter inVMAccessControlProfileVersionName is required and cannot be null."));
        }
        String apiVersion = "2025-03-03";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), "2025-03-03", this.client.getSubscriptionId(), resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        if (inVMAccessControlProfileVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter inVMAccessControlProfileVersionName is required and cannot be null."));
        }
        String apiVersion = "2025-03-03";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), "2025-03-03", this.client.getSubscriptionId(), resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName) {
        return this.beginDeleteAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName) {
        return this.beginDeleteAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName) {
        this.deleteAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String galleryName, String inVMAccessControlProfileName, String inVMAccessControlProfileVersionName, Context context) {
        this.deleteAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, inVMAccessControlProfileVersionName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryInVMAccessControlProfileVersionInner>> listByGalleryInVMAccessControlProfileNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByGalleryInVMAccessControlProfileNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GalleryInVMAccessControlProfileVersionList)res.getValue()).value(), ((GalleryInVMAccessControlProfileVersionList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryInVMAccessControlProfileVersionInner>> listByGalleryInVMAccessControlProfileNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByGalleryInVMAccessControlProfileNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GalleryInVMAccessControlProfileVersionList)res.getValue()).value(), ((GalleryInVMAccessControlProfileVersionList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ComputeManagementClientGalleryInVMAccessControlProfileVersions")
    public static interface GalleryInVMAccessControlProfileVersionsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/inVMAccessControlProfiles/{inVMAccessControlProfileName}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<GalleryInVMAccessControlProfileVersionList>> listByGalleryInVMAccessControlProfile(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="galleryName") String var5, @PathParam(value="inVMAccessControlProfileName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/inVMAccessControlProfiles/{inVMAccessControlProfileName}/versions/{inVMAccessControlProfileVersionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<GalleryInVMAccessControlProfileVersionInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="galleryName") String var5, @PathParam(value="inVMAccessControlProfileName") String var6, @PathParam(value="inVMAccessControlProfileVersionName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/inVMAccessControlProfiles/{inVMAccessControlProfileName}/versions/{inVMAccessControlProfileVersionName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="galleryName") String var5, @PathParam(value="inVMAccessControlProfileName") String var6, @PathParam(value="inVMAccessControlProfileVersionName") String var7, @BodyParam(value="application/json") GalleryInVMAccessControlProfileVersionInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/inVMAccessControlProfiles/{inVMAccessControlProfileName}/versions/{inVMAccessControlProfileVersionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="galleryName") String var5, @PathParam(value="inVMAccessControlProfileName") String var6, @PathParam(value="inVMAccessControlProfileVersionName") String var7, @BodyParam(value="application/json") GalleryInVMAccessControlProfileVersionUpdate var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/inVMAccessControlProfiles/{inVMAccessControlProfileName}/versions/{inVMAccessControlProfileVersionName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="galleryName") String var5, @PathParam(value="inVMAccessControlProfileName") String var6, @PathParam(value="inVMAccessControlProfileVersionName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<GalleryInVMAccessControlProfileVersionList>> listByGalleryInVMAccessControlProfileNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

