/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.management.SubResource;
import com.azure.resourcemanager.compute.implementation.VirtualMachineCustomImageImpl;
import com.azure.resourcemanager.compute.models.CachingTypes;
import com.azure.resourcemanager.compute.models.Disk;
import com.azure.resourcemanager.compute.models.ImageDataDisk;
import com.azure.resourcemanager.compute.models.VirtualMachineCustomImage;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;

class CustomImageDataDiskImpl
extends ChildResourceImpl<ImageDataDisk, VirtualMachineCustomImageImpl, VirtualMachineCustomImage>
implements VirtualMachineCustomImage.CustomImageDataDisk,
VirtualMachineCustomImage.CustomImageDataDisk.Definition<VirtualMachineCustomImage.DefinitionStages.WithCreateAndDataDiskImageOSDiskSettings> {
    CustomImageDataDiskImpl(ImageDataDisk inner, VirtualMachineCustomImageImpl parent) {
        super((Object)inner, (Object)parent);
    }

    public CustomImageDataDiskImpl withDiskSizeInGB(int diskSizeGB) {
        ((ImageDataDisk)this.innerModel()).withDiskSizeGB(diskSizeGB);
        return this;
    }

    public CustomImageDataDiskImpl withDiskCaching(CachingTypes cachingType) {
        ((ImageDataDisk)this.innerModel()).withCaching(cachingType);
        return this;
    }

    public CustomImageDataDiskImpl withLun(int lun) {
        ((ImageDataDisk)this.innerModel()).withLun(lun);
        return this;
    }

    public CustomImageDataDiskImpl fromVhd(String sourceVhdUrl) {
        ((ImageDataDisk)this.innerModel()).withBlobUri(sourceVhdUrl);
        return this;
    }

    public CustomImageDataDiskImpl fromSnapshot(String sourceSnapshotId) {
        ((ImageDataDisk)this.innerModel()).withSnapshot(new SubResource().withId(sourceSnapshotId));
        return this;
    }

    public CustomImageDataDiskImpl fromManagedDisk(String sourceManagedDiskId) {
        ((ImageDataDisk)this.innerModel()).withManagedDisk(new SubResource().withId(sourceManagedDiskId));
        return this;
    }

    public CustomImageDataDiskImpl fromManagedDisk(Disk sourceManagedDisk) {
        ((ImageDataDisk)this.innerModel()).withManagedDisk(new SubResource().withId(sourceManagedDisk.id()));
        return this;
    }

    public String name() {
        return Integer.toString(((ImageDataDisk)this.innerModel()).lun());
    }

    public VirtualMachineCustomImageImpl attach() {
        return ((VirtualMachineCustomImageImpl)this.parent()).withCustomImageDataDisk(this);
    }
}

