/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.GalleryProvisioningState;
import com.azure.resourcemanager.compute.models.GalleryScriptVersionPublishingProfile;
import com.azure.resourcemanager.compute.models.GalleryScriptVersionSafetyProfile;
import com.azure.resourcemanager.compute.models.ReplicationStatus;
import java.io.IOException;

public final class GalleryScriptVersionProperties
implements JsonSerializable<GalleryScriptVersionProperties> {
    private GalleryScriptVersionPublishingProfile publishingProfile;
    private GalleryScriptVersionSafetyProfile safetyProfile;
    private GalleryProvisioningState provisioningState;
    private ReplicationStatus replicationStatus;
    private static final ClientLogger LOGGER = new ClientLogger(GalleryScriptVersionProperties.class);

    public GalleryScriptVersionPublishingProfile publishingProfile() {
        return this.publishingProfile;
    }

    public GalleryScriptVersionProperties withPublishingProfile(GalleryScriptVersionPublishingProfile publishingProfile) {
        this.publishingProfile = publishingProfile;
        return this;
    }

    public GalleryScriptVersionSafetyProfile safetyProfile() {
        return this.safetyProfile;
    }

    public GalleryScriptVersionProperties withSafetyProfile(GalleryScriptVersionSafetyProfile safetyProfile) {
        this.safetyProfile = safetyProfile;
        return this;
    }

    public GalleryProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public ReplicationStatus replicationStatus() {
        return this.replicationStatus;
    }

    public void validate() {
        if (this.publishingProfile() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property publishingProfile in model GalleryScriptVersionProperties"));
        }
        this.publishingProfile().validate();
        if (this.safetyProfile() != null) {
            this.safetyProfile().validate();
        }
        if (this.replicationStatus() != null) {
            this.replicationStatus().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("publishingProfile", (JsonSerializable)this.publishingProfile);
        jsonWriter.writeJsonField("safetyProfile", (JsonSerializable)this.safetyProfile);
        return jsonWriter.writeEndObject();
    }

    public static GalleryScriptVersionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (GalleryScriptVersionProperties)jsonReader.readObject(reader -> {
            GalleryScriptVersionProperties deserializedGalleryScriptVersionProperties = new GalleryScriptVersionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("publishingProfile".equals(fieldName)) {
                    deserializedGalleryScriptVersionProperties.publishingProfile = GalleryScriptVersionPublishingProfile.fromJson(reader);
                    continue;
                }
                if ("safetyProfile".equals(fieldName)) {
                    deserializedGalleryScriptVersionProperties.safetyProfile = GalleryScriptVersionSafetyProfile.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedGalleryScriptVersionProperties.provisioningState = GalleryProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("replicationStatus".equals(fieldName)) {
                    deserializedGalleryScriptVersionProperties.replicationStatus = ReplicationStatus.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryScriptVersionProperties;
        });
    }
}

