/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.GalleryProvisioningState;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class GalleryScriptProperties
implements JsonSerializable<GalleryScriptProperties> {
    private String description;
    private String eula;
    private String privacyStatementUri;
    private String releaseNoteUri;
    private OffsetDateTime endOfLifeDate;
    private OperatingSystemTypes supportedOSType;
    private GalleryProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(GalleryScriptProperties.class);

    public String description() {
        return this.description;
    }

    public GalleryScriptProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String eula() {
        return this.eula;
    }

    public GalleryScriptProperties withEula(String eula) {
        this.eula = eula;
        return this;
    }

    public String privacyStatementUri() {
        return this.privacyStatementUri;
    }

    public GalleryScriptProperties withPrivacyStatementUri(String privacyStatementUri) {
        this.privacyStatementUri = privacyStatementUri;
        return this;
    }

    public String releaseNoteUri() {
        return this.releaseNoteUri;
    }

    public GalleryScriptProperties withReleaseNoteUri(String releaseNoteUri) {
        this.releaseNoteUri = releaseNoteUri;
        return this;
    }

    public OffsetDateTime endOfLifeDate() {
        return this.endOfLifeDate;
    }

    public GalleryScriptProperties withEndOfLifeDate(OffsetDateTime endOfLifeDate) {
        this.endOfLifeDate = endOfLifeDate;
        return this;
    }

    public OperatingSystemTypes supportedOSType() {
        return this.supportedOSType;
    }

    public GalleryScriptProperties withSupportedOSType(OperatingSystemTypes supportedOSType) {
        this.supportedOSType = supportedOSType;
        return this;
    }

    public GalleryProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.supportedOSType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property supportedOSType in model GalleryScriptProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("supportedOSType", this.supportedOSType == null ? null : this.supportedOSType.toString());
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("eula", this.eula);
        jsonWriter.writeStringField("privacyStatementUri", this.privacyStatementUri);
        jsonWriter.writeStringField("releaseNoteUri", this.releaseNoteUri);
        jsonWriter.writeStringField("endOfLifeDate", this.endOfLifeDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endOfLifeDate));
        return jsonWriter.writeEndObject();
    }

    public static GalleryScriptProperties fromJson(JsonReader jsonReader) throws IOException {
        return (GalleryScriptProperties)jsonReader.readObject(reader -> {
            GalleryScriptProperties deserializedGalleryScriptProperties = new GalleryScriptProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("supportedOSType".equals(fieldName)) {
                    deserializedGalleryScriptProperties.supportedOSType = OperatingSystemTypes.fromString(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedGalleryScriptProperties.description = reader.getString();
                    continue;
                }
                if ("eula".equals(fieldName)) {
                    deserializedGalleryScriptProperties.eula = reader.getString();
                    continue;
                }
                if ("privacyStatementUri".equals(fieldName)) {
                    deserializedGalleryScriptProperties.privacyStatementUri = reader.getString();
                    continue;
                }
                if ("releaseNoteUri".equals(fieldName)) {
                    deserializedGalleryScriptProperties.releaseNoteUri = reader.getString();
                    continue;
                }
                if ("endOfLifeDate".equals(fieldName)) {
                    deserializedGalleryScriptProperties.endOfLifeDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedGalleryScriptProperties.provisioningState = GalleryProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryScriptProperties;
        });
    }
}

