/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.GalleryScriptParameter;
import java.io.IOException;
import java.util.List;

public final class ScriptSource
implements JsonSerializable<ScriptSource> {
    private String scriptLink;
    private List<GalleryScriptParameter> parameters;
    private static final ClientLogger LOGGER = new ClientLogger(ScriptSource.class);

    public String scriptLink() {
        return this.scriptLink;
    }

    public ScriptSource withScriptLink(String scriptLink) {
        this.scriptLink = scriptLink;
        return this;
    }

    public List<GalleryScriptParameter> parameters() {
        return this.parameters;
    }

    public ScriptSource withParameters(List<GalleryScriptParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public void validate() {
        if (this.scriptLink() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property scriptLink in model ScriptSource"));
        }
        if (this.parameters() != null) {
            this.parameters().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scriptLink", this.scriptLink);
        jsonWriter.writeArrayField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ScriptSource fromJson(JsonReader jsonReader) throws IOException {
        return (ScriptSource)jsonReader.readObject(reader -> {
            ScriptSource deserializedScriptSource = new ScriptSource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scriptLink".equals(fieldName)) {
                    deserializedScriptSource.scriptLink = reader.getString();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    List parameters;
                    deserializedScriptSource.parameters = parameters = reader.readArray(reader1 -> GalleryScriptParameter.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScriptSource;
        });
    }
}

