/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class GenericGalleryParameter
implements JsonSerializable<GenericGalleryParameter> {
    private String name;
    private Boolean required;
    private String defaultValue;
    private String description;
    private static final ClientLogger LOGGER = new ClientLogger(GenericGalleryParameter.class);

    public String name() {
        return this.name;
    }

    public GenericGalleryParameter withName(String name) {
        this.name = name;
        return this;
    }

    public Boolean required() {
        return this.required;
    }

    public GenericGalleryParameter withRequired(Boolean required) {
        this.required = required;
        return this;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public GenericGalleryParameter withDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public String description() {
        return this.description;
    }

    public GenericGalleryParameter withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model GenericGalleryParameter"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeBooleanField("required", this.required);
        jsonWriter.writeStringField("defaultValue", this.defaultValue);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static GenericGalleryParameter fromJson(JsonReader jsonReader) throws IOException {
        return (GenericGalleryParameter)jsonReader.readObject(reader -> {
            GenericGalleryParameter deserializedGenericGalleryParameter = new GenericGalleryParameter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedGenericGalleryParameter.name = reader.getString();
                    continue;
                }
                if ("required".equals(fieldName)) {
                    deserializedGenericGalleryParameter.required = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("defaultValue".equals(fieldName)) {
                    deserializedGenericGalleryParameter.defaultValue = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedGenericGalleryParameter.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGenericGalleryParameter;
        });
    }
}

