/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.GalleryArtifactPublishingProfileBase;
import com.azure.resourcemanager.compute.models.GalleryTargetExtendedLocation;
import com.azure.resourcemanager.compute.models.ReplicationMode;
import com.azure.resourcemanager.compute.models.ScriptSource;
import com.azure.resourcemanager.compute.models.StorageAccountStrategy;
import com.azure.resourcemanager.compute.models.StorageAccountType;
import com.azure.resourcemanager.compute.models.TargetRegion;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class GalleryScriptVersionPublishingProfile
extends GalleryArtifactPublishingProfileBase {
    private ScriptSource source;
    private OffsetDateTime publishedDate;
    private static final ClientLogger LOGGER = new ClientLogger(GalleryScriptVersionPublishingProfile.class);

    public ScriptSource source() {
        return this.source;
    }

    public GalleryScriptVersionPublishingProfile withSource(ScriptSource source) {
        this.source = source;
        return this;
    }

    @Override
    public OffsetDateTime publishedDate() {
        return this.publishedDate;
    }

    @Override
    public GalleryScriptVersionPublishingProfile withTargetRegions(List<TargetRegion> targetRegions) {
        super.withTargetRegions(targetRegions);
        return this;
    }

    @Override
    public GalleryScriptVersionPublishingProfile withReplicaCount(Integer replicaCount) {
        super.withReplicaCount(replicaCount);
        return this;
    }

    @Override
    public GalleryScriptVersionPublishingProfile withExcludeFromLatest(Boolean excludeFromLatest) {
        super.withExcludeFromLatest(excludeFromLatest);
        return this;
    }

    @Override
    public GalleryScriptVersionPublishingProfile withEndOfLifeDate(OffsetDateTime endOfLifeDate) {
        super.withEndOfLifeDate(endOfLifeDate);
        return this;
    }

    @Override
    public GalleryScriptVersionPublishingProfile withStorageAccountType(StorageAccountType storageAccountType) {
        super.withStorageAccountType(storageAccountType);
        return this;
    }

    @Override
    public GalleryScriptVersionPublishingProfile withReplicationMode(ReplicationMode replicationMode) {
        super.withReplicationMode(replicationMode);
        return this;
    }

    @Override
    public GalleryScriptVersionPublishingProfile withTargetExtendedLocations(List<GalleryTargetExtendedLocation> targetExtendedLocations) {
        super.withTargetExtendedLocations(targetExtendedLocations);
        return this;
    }

    @Override
    public GalleryScriptVersionPublishingProfile withStorageAccountStrategy(StorageAccountStrategy storageAccountStrategy) {
        super.withStorageAccountStrategy(storageAccountStrategy);
        return this;
    }

    @Override
    public void validate() {
        if (this.source() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property source in model GalleryScriptVersionPublishingProfile"));
        }
        this.source().validate();
        if (this.targetRegions() != null) {
            this.targetRegions().forEach(e -> e.validate());
        }
        if (this.targetExtendedLocations() != null) {
            this.targetExtendedLocations().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("targetRegions", this.targetRegions(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("replicaCount", (Number)this.replicaCount());
        jsonWriter.writeBooleanField("excludeFromLatest", this.excludeFromLatest());
        jsonWriter.writeStringField("endOfLifeDate", this.endOfLifeDate() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endOfLifeDate()));
        jsonWriter.writeStringField("storageAccountType", this.storageAccountType() == null ? null : this.storageAccountType().toString());
        jsonWriter.writeStringField("replicationMode", this.replicationMode() == null ? null : this.replicationMode().toString());
        jsonWriter.writeArrayField("targetExtendedLocations", this.targetExtendedLocations(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("storageAccountStrategy", this.storageAccountStrategy() == null ? null : this.storageAccountStrategy().toString());
        jsonWriter.writeJsonField("source", (JsonSerializable)this.source);
        return jsonWriter.writeEndObject();
    }

    public static GalleryScriptVersionPublishingProfile fromJson(JsonReader jsonReader) throws IOException {
        return (GalleryScriptVersionPublishingProfile)jsonReader.readObject(reader -> {
            GalleryScriptVersionPublishingProfile deserializedGalleryScriptVersionPublishingProfile = new GalleryScriptVersionPublishingProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetRegions".equals(fieldName)) {
                    List targetRegions = reader.readArray(reader1 -> TargetRegion.fromJson(reader1));
                    deserializedGalleryScriptVersionPublishingProfile.withTargetRegions(targetRegions);
                    continue;
                }
                if ("replicaCount".equals(fieldName)) {
                    deserializedGalleryScriptVersionPublishingProfile.withReplicaCount((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("excludeFromLatest".equals(fieldName)) {
                    deserializedGalleryScriptVersionPublishingProfile.withExcludeFromLatest((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("publishedDate".equals(fieldName)) {
                    deserializedGalleryScriptVersionPublishingProfile.publishedDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endOfLifeDate".equals(fieldName)) {
                    deserializedGalleryScriptVersionPublishingProfile.withEndOfLifeDate((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("storageAccountType".equals(fieldName)) {
                    deserializedGalleryScriptVersionPublishingProfile.withStorageAccountType(StorageAccountType.fromString(reader.getString()));
                    continue;
                }
                if ("replicationMode".equals(fieldName)) {
                    deserializedGalleryScriptVersionPublishingProfile.withReplicationMode(ReplicationMode.fromString(reader.getString()));
                    continue;
                }
                if ("targetExtendedLocations".equals(fieldName)) {
                    List targetExtendedLocations = reader.readArray(reader1 -> GalleryTargetExtendedLocation.fromJson(reader1));
                    deserializedGalleryScriptVersionPublishingProfile.withTargetExtendedLocations(targetExtendedLocations);
                    continue;
                }
                if ("storageAccountStrategy".equals(fieldName)) {
                    deserializedGalleryScriptVersionPublishingProfile.withStorageAccountStrategy(StorageAccountStrategy.fromString(reader.getString()));
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedGalleryScriptVersionPublishingProfile.source = ScriptSource.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryScriptVersionPublishingProfile;
        });
    }
}

