/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.GalleryScriptProperties;
import com.azure.resourcemanager.compute.models.GalleryProvisioningState;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.UpdateResourceDefinition;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class GalleryScriptUpdate
extends UpdateResourceDefinition {
    private GalleryScriptProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private GalleryScriptProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public GalleryScriptUpdate withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public GalleryScriptUpdate withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryScriptProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public String eula() {
        return this.innerProperties() == null ? null : this.innerProperties().eula();
    }

    public GalleryScriptUpdate withEula(String eula) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryScriptProperties();
        }
        this.innerProperties().withEula(eula);
        return this;
    }

    public String privacyStatementUri() {
        return this.innerProperties() == null ? null : this.innerProperties().privacyStatementUri();
    }

    public GalleryScriptUpdate withPrivacyStatementUri(String privacyStatementUri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryScriptProperties();
        }
        this.innerProperties().withPrivacyStatementUri(privacyStatementUri);
        return this;
    }

    public String releaseNoteUri() {
        return this.innerProperties() == null ? null : this.innerProperties().releaseNoteUri();
    }

    public GalleryScriptUpdate withReleaseNoteUri(String releaseNoteUri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryScriptProperties();
        }
        this.innerProperties().withReleaseNoteUri(releaseNoteUri);
        return this;
    }

    public OffsetDateTime endOfLifeDate() {
        return this.innerProperties() == null ? null : this.innerProperties().endOfLifeDate();
    }

    public GalleryScriptUpdate withEndOfLifeDate(OffsetDateTime endOfLifeDate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryScriptProperties();
        }
        this.innerProperties().withEndOfLifeDate(endOfLifeDate);
        return this;
    }

    public OperatingSystemTypes supportedOSType() {
        return this.innerProperties() == null ? null : this.innerProperties().supportedOSType();
    }

    public GalleryScriptUpdate withSupportedOSType(OperatingSystemTypes supportedOSType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryScriptProperties();
        }
        this.innerProperties().withSupportedOSType(supportedOSType);
        return this;
    }

    public GalleryProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static GalleryScriptUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (GalleryScriptUpdate)jsonReader.readObject(reader -> {
            GalleryScriptUpdate deserializedGalleryScriptUpdate = new GalleryScriptUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedGalleryScriptUpdate.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedGalleryScriptUpdate.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedGalleryScriptUpdate.type = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedGalleryScriptUpdate.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedGalleryScriptUpdate.innerProperties = GalleryScriptProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryScriptUpdate;
        });
    }
}

