/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.GalleryScriptParameterType;
import com.azure.resourcemanager.compute.models.GenericGalleryParameter;
import java.io.IOException;
import java.util.List;

public final class GalleryScriptParameter
extends GenericGalleryParameter {
    private GalleryScriptParameterType type;
    private String minValue;
    private String maxValue;
    private List<String> enumValues;
    private static final ClientLogger LOGGER = new ClientLogger(GalleryScriptParameter.class);

    public GalleryScriptParameterType type() {
        return this.type;
    }

    public GalleryScriptParameter withType(GalleryScriptParameterType type) {
        this.type = type;
        return this;
    }

    public String minValue() {
        return this.minValue;
    }

    public GalleryScriptParameter withMinValue(String minValue) {
        this.minValue = minValue;
        return this;
    }

    public String maxValue() {
        return this.maxValue;
    }

    public GalleryScriptParameter withMaxValue(String maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    public List<String> enumValues() {
        return this.enumValues;
    }

    public GalleryScriptParameter withEnumValues(List<String> enumValues) {
        this.enumValues = enumValues;
        return this;
    }

    @Override
    public GalleryScriptParameter withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public GalleryScriptParameter withRequired(Boolean required) {
        super.withRequired(required);
        return this;
    }

    @Override
    public GalleryScriptParameter withDefaultValue(String defaultValue) {
        super.withDefaultValue(defaultValue);
        return this;
    }

    @Override
    public GalleryScriptParameter withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model GalleryScriptParameter"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeBooleanField("required", this.required());
        jsonWriter.writeStringField("defaultValue", this.defaultValue());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("minValue", this.minValue);
        jsonWriter.writeStringField("maxValue", this.maxValue);
        jsonWriter.writeArrayField("enumValues", this.enumValues, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static GalleryScriptParameter fromJson(JsonReader jsonReader) throws IOException {
        return (GalleryScriptParameter)jsonReader.readObject(reader -> {
            GalleryScriptParameter deserializedGalleryScriptParameter = new GalleryScriptParameter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedGalleryScriptParameter.withName(reader.getString());
                    continue;
                }
                if ("required".equals(fieldName)) {
                    deserializedGalleryScriptParameter.withRequired((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("defaultValue".equals(fieldName)) {
                    deserializedGalleryScriptParameter.withDefaultValue(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedGalleryScriptParameter.withDescription(reader.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedGalleryScriptParameter.type = GalleryScriptParameterType.fromString(reader.getString());
                    continue;
                }
                if ("minValue".equals(fieldName)) {
                    deserializedGalleryScriptParameter.minValue = reader.getString();
                    continue;
                }
                if ("maxValue".equals(fieldName)) {
                    deserializedGalleryScriptParameter.maxValue = reader.getString();
                    continue;
                }
                if ("enumValues".equals(fieldName)) {
                    List enumValues;
                    deserializedGalleryScriptParameter.enumValues = enumValues = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryScriptParameter;
        });
    }
}

