/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.GalleryTargetExtendedLocation;
import com.azure.resourcemanager.compute.models.ReplicationMode;
import com.azure.resourcemanager.compute.models.StorageAccountStrategy;
import com.azure.resourcemanager.compute.models.StorageAccountType;
import com.azure.resourcemanager.compute.models.TargetRegion;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public class GalleryArtifactPublishingProfileBase
implements JsonSerializable<GalleryArtifactPublishingProfileBase> {
    private List<TargetRegion> targetRegions;
    private Integer replicaCount;
    private Boolean excludeFromLatest;
    private OffsetDateTime publishedDate;
    private OffsetDateTime endOfLifeDate;
    private StorageAccountType storageAccountType;
    private ReplicationMode replicationMode;
    private List<GalleryTargetExtendedLocation> targetExtendedLocations;
    private StorageAccountStrategy storageAccountStrategy;

    public List<TargetRegion> targetRegions() {
        return this.targetRegions;
    }

    public GalleryArtifactPublishingProfileBase withTargetRegions(List<TargetRegion> targetRegions) {
        this.targetRegions = targetRegions;
        return this;
    }

    public Integer replicaCount() {
        return this.replicaCount;
    }

    public GalleryArtifactPublishingProfileBase withReplicaCount(Integer replicaCount) {
        this.replicaCount = replicaCount;
        return this;
    }

    public Boolean excludeFromLatest() {
        return this.excludeFromLatest;
    }

    public GalleryArtifactPublishingProfileBase withExcludeFromLatest(Boolean excludeFromLatest) {
        this.excludeFromLatest = excludeFromLatest;
        return this;
    }

    public OffsetDateTime publishedDate() {
        return this.publishedDate;
    }

    GalleryArtifactPublishingProfileBase withPublishedDate(OffsetDateTime publishedDate) {
        this.publishedDate = publishedDate;
        return this;
    }

    public OffsetDateTime endOfLifeDate() {
        return this.endOfLifeDate;
    }

    public GalleryArtifactPublishingProfileBase withEndOfLifeDate(OffsetDateTime endOfLifeDate) {
        this.endOfLifeDate = endOfLifeDate;
        return this;
    }

    public StorageAccountType storageAccountType() {
        return this.storageAccountType;
    }

    public GalleryArtifactPublishingProfileBase withStorageAccountType(StorageAccountType storageAccountType) {
        this.storageAccountType = storageAccountType;
        return this;
    }

    public ReplicationMode replicationMode() {
        return this.replicationMode;
    }

    public GalleryArtifactPublishingProfileBase withReplicationMode(ReplicationMode replicationMode) {
        this.replicationMode = replicationMode;
        return this;
    }

    public List<GalleryTargetExtendedLocation> targetExtendedLocations() {
        return this.targetExtendedLocations;
    }

    public GalleryArtifactPublishingProfileBase withTargetExtendedLocations(List<GalleryTargetExtendedLocation> targetExtendedLocations) {
        this.targetExtendedLocations = targetExtendedLocations;
        return this;
    }

    public StorageAccountStrategy storageAccountStrategy() {
        return this.storageAccountStrategy;
    }

    public GalleryArtifactPublishingProfileBase withStorageAccountStrategy(StorageAccountStrategy storageAccountStrategy) {
        this.storageAccountStrategy = storageAccountStrategy;
        return this;
    }

    public void validate() {
        if (this.targetRegions() != null) {
            this.targetRegions().forEach(e -> e.validate());
        }
        if (this.targetExtendedLocations() != null) {
            this.targetExtendedLocations().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("targetRegions", this.targetRegions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("replicaCount", (Number)this.replicaCount);
        jsonWriter.writeBooleanField("excludeFromLatest", this.excludeFromLatest);
        jsonWriter.writeStringField("endOfLifeDate", this.endOfLifeDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endOfLifeDate));
        jsonWriter.writeStringField("storageAccountType", this.storageAccountType == null ? null : this.storageAccountType.toString());
        jsonWriter.writeStringField("replicationMode", this.replicationMode == null ? null : this.replicationMode.toString());
        jsonWriter.writeArrayField("targetExtendedLocations", this.targetExtendedLocations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("storageAccountStrategy", this.storageAccountStrategy == null ? null : this.storageAccountStrategy.toString());
        return jsonWriter.writeEndObject();
    }

    public static GalleryArtifactPublishingProfileBase fromJson(JsonReader jsonReader) throws IOException {
        return (GalleryArtifactPublishingProfileBase)jsonReader.readObject(reader -> {
            GalleryArtifactPublishingProfileBase deserializedGalleryArtifactPublishingProfileBase = new GalleryArtifactPublishingProfileBase();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetRegions".equals(fieldName)) {
                    List targetRegions;
                    deserializedGalleryArtifactPublishingProfileBase.targetRegions = targetRegions = reader.readArray(reader1 -> TargetRegion.fromJson(reader1));
                    continue;
                }
                if ("replicaCount".equals(fieldName)) {
                    deserializedGalleryArtifactPublishingProfileBase.replicaCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("excludeFromLatest".equals(fieldName)) {
                    deserializedGalleryArtifactPublishingProfileBase.excludeFromLatest = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("publishedDate".equals(fieldName)) {
                    deserializedGalleryArtifactPublishingProfileBase.publishedDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endOfLifeDate".equals(fieldName)) {
                    deserializedGalleryArtifactPublishingProfileBase.endOfLifeDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("storageAccountType".equals(fieldName)) {
                    deserializedGalleryArtifactPublishingProfileBase.storageAccountType = StorageAccountType.fromString(reader.getString());
                    continue;
                }
                if ("replicationMode".equals(fieldName)) {
                    deserializedGalleryArtifactPublishingProfileBase.replicationMode = ReplicationMode.fromString(reader.getString());
                    continue;
                }
                if ("targetExtendedLocations".equals(fieldName)) {
                    List targetExtendedLocations;
                    deserializedGalleryArtifactPublishingProfileBase.targetExtendedLocations = targetExtendedLocations = reader.readArray(reader1 -> GalleryTargetExtendedLocation.fromJson(reader1));
                    continue;
                }
                if ("storageAccountStrategy".equals(fieldName)) {
                    deserializedGalleryArtifactPublishingProfileBase.storageAccountStrategy = StorageAccountStrategy.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryArtifactPublishingProfileBase;
        });
    }
}

