/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.compute.fluent.GalleryScriptVersionsClient;
import com.azure.resourcemanager.compute.fluent.models.GalleryScriptVersionInner;
import com.azure.resourcemanager.compute.implementation.ComputeManagementClientImpl;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.GalleryScriptVersionList;
import com.azure.resourcemanager.compute.models.GalleryScriptVersionUpdate;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class GalleryScriptVersionsClientImpl
implements GalleryScriptVersionsClient {
    private final GalleryScriptVersionsService service;
    private final ComputeManagementClientImpl client;

    GalleryScriptVersionsClientImpl(ComputeManagementClientImpl client) {
        this.service = (GalleryScriptVersionsService)RestProxy.create(GalleryScriptVersionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryScriptVersionInner>> listByGalleryScriptSinglePageAsync(String resourceGroupName, String galleryName, String galleryScriptName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryScriptName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScriptName is required and cannot be null."));
        }
        String apiVersion = "2025-03-03";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByGalleryScript(this.client.getEndpoint(), "2025-03-03", this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryScriptName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GalleryScriptVersionList)res.getValue()).value(), ((GalleryScriptVersionList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryScriptVersionInner>> listByGalleryScriptSinglePageAsync(String resourceGroupName, String galleryName, String galleryScriptName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryScriptName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScriptName is required and cannot be null."));
        }
        String apiVersion = "2025-03-03";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByGalleryScript(this.client.getEndpoint(), "2025-03-03", this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryScriptName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GalleryScriptVersionList)res.getValue()).value(), ((GalleryScriptVersionList)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<GalleryScriptVersionInner> listByGalleryScriptAsync(String resourceGroupName, String galleryName, String galleryScriptName) {
        return new PagedFlux(() -> this.listByGalleryScriptSinglePageAsync(resourceGroupName, galleryName, galleryScriptName), nextLink -> this.listByGalleryScriptNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<GalleryScriptVersionInner> listByGalleryScriptAsync(String resourceGroupName, String galleryName, String galleryScriptName, Context context) {
        return new PagedFlux(() -> this.listByGalleryScriptSinglePageAsync(resourceGroupName, galleryName, galleryScriptName, context), nextLink -> this.listByGalleryScriptNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<GalleryScriptVersionInner> listByGalleryScript(String resourceGroupName, String galleryName, String galleryScriptName) {
        return new PagedIterable(this.listByGalleryScriptAsync(resourceGroupName, galleryName, galleryScriptName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<GalleryScriptVersionInner> listByGalleryScript(String resourceGroupName, String galleryName, String galleryScriptName, Context context) {
        return new PagedIterable(this.listByGalleryScriptAsync(resourceGroupName, galleryName, galleryScriptName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<GalleryScriptVersionInner>> getWithResponseAsync(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryScriptName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScriptName is required and cannot be null."));
        }
        if (galleryScriptVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScriptVersionName is required and cannot be null."));
        }
        String apiVersion = "2025-03-03";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2025-03-03", this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GalleryScriptVersionInner>> getWithResponseAsync(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryScriptName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScriptName is required and cannot be null."));
        }
        if (galleryScriptVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScriptVersionName is required and cannot be null."));
        }
        String apiVersion = "2025-03-03";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2025-03-03", this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<GalleryScriptVersionInner> getAsync(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName) {
        return this.getWithResponseAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((GalleryScriptVersionInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<GalleryScriptVersionInner> getWithResponse(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GalleryScriptVersionInner get(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName) {
        return (GalleryScriptVersionInner)((Object)this.getWithResponse(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName, GalleryScriptVersionInner galleryScriptVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryScriptName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScriptName is required and cannot be null."));
        }
        if (galleryScriptVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScriptVersionName is required and cannot be null."));
        }
        if (galleryScriptVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScriptVersion is required and cannot be null."));
        }
        galleryScriptVersion.validate();
        String apiVersion = "2025-03-03";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), "2025-03-03", this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, galleryScriptVersion, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName, GalleryScriptVersionInner galleryScriptVersion, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryScriptName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScriptName is required and cannot be null."));
        }
        if (galleryScriptVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScriptVersionName is required and cannot be null."));
        }
        if (galleryScriptVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScriptVersion is required and cannot be null."));
        }
        galleryScriptVersion.validate();
        String apiVersion = "2025-03-03";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), "2025-03-03", this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, galleryScriptVersion, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<GalleryScriptVersionInner>, GalleryScriptVersionInner> beginCreateOrUpdateAsync(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName, GalleryScriptVersionInner galleryScriptVersion) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, galleryScriptVersion);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)GalleryScriptVersionInner.class), (Type)((Object)GalleryScriptVersionInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<GalleryScriptVersionInner>, GalleryScriptVersionInner> beginCreateOrUpdateAsync(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName, GalleryScriptVersionInner galleryScriptVersion, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, galleryScriptVersion, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)GalleryScriptVersionInner.class), (Type)((Object)GalleryScriptVersionInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GalleryScriptVersionInner>, GalleryScriptVersionInner> beginCreateOrUpdate(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName, GalleryScriptVersionInner galleryScriptVersion) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, galleryScriptVersion).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GalleryScriptVersionInner>, GalleryScriptVersionInner> beginCreateOrUpdate(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName, GalleryScriptVersionInner galleryScriptVersion, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, galleryScriptVersion, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<GalleryScriptVersionInner> createOrUpdateAsync(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName, GalleryScriptVersionInner galleryScriptVersion) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, galleryScriptVersion).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GalleryScriptVersionInner> createOrUpdateAsync(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName, GalleryScriptVersionInner galleryScriptVersion, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, galleryScriptVersion, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GalleryScriptVersionInner createOrUpdate(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName, GalleryScriptVersionInner galleryScriptVersion) {
        return (GalleryScriptVersionInner)((Object)this.createOrUpdateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, galleryScriptVersion).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GalleryScriptVersionInner createOrUpdate(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName, GalleryScriptVersionInner galleryScriptVersion, Context context) {
        return (GalleryScriptVersionInner)((Object)this.createOrUpdateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, galleryScriptVersion, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName, GalleryScriptVersionUpdate galleryScriptVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryScriptName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScriptName is required and cannot be null."));
        }
        if (galleryScriptVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScriptVersionName is required and cannot be null."));
        }
        if (galleryScriptVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScriptVersion is required and cannot be null."));
        }
        galleryScriptVersion.validate();
        String apiVersion = "2025-03-03";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), "2025-03-03", this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, galleryScriptVersion, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName, GalleryScriptVersionUpdate galleryScriptVersion, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryScriptName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScriptName is required and cannot be null."));
        }
        if (galleryScriptVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScriptVersionName is required and cannot be null."));
        }
        if (galleryScriptVersion == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScriptVersion is required and cannot be null."));
        }
        galleryScriptVersion.validate();
        String apiVersion = "2025-03-03";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), "2025-03-03", this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, galleryScriptVersion, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<GalleryScriptVersionInner>, GalleryScriptVersionInner> beginUpdateAsync(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName, GalleryScriptVersionUpdate galleryScriptVersion) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, galleryScriptVersion);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)GalleryScriptVersionInner.class), (Type)((Object)GalleryScriptVersionInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<GalleryScriptVersionInner>, GalleryScriptVersionInner> beginUpdateAsync(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName, GalleryScriptVersionUpdate galleryScriptVersion, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, galleryScriptVersion, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)GalleryScriptVersionInner.class), (Type)((Object)GalleryScriptVersionInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GalleryScriptVersionInner>, GalleryScriptVersionInner> beginUpdate(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName, GalleryScriptVersionUpdate galleryScriptVersion) {
        return this.beginUpdateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, galleryScriptVersion).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GalleryScriptVersionInner>, GalleryScriptVersionInner> beginUpdate(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName, GalleryScriptVersionUpdate galleryScriptVersion, Context context) {
        return this.beginUpdateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, galleryScriptVersion, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<GalleryScriptVersionInner> updateAsync(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName, GalleryScriptVersionUpdate galleryScriptVersion) {
        return this.beginUpdateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, galleryScriptVersion).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GalleryScriptVersionInner> updateAsync(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName, GalleryScriptVersionUpdate galleryScriptVersion, Context context) {
        return this.beginUpdateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, galleryScriptVersion, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GalleryScriptVersionInner update(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName, GalleryScriptVersionUpdate galleryScriptVersion) {
        return (GalleryScriptVersionInner)((Object)this.updateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, galleryScriptVersion).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GalleryScriptVersionInner update(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName, GalleryScriptVersionUpdate galleryScriptVersion, Context context) {
        return (GalleryScriptVersionInner)((Object)this.updateAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, galleryScriptVersion, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryScriptName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScriptName is required and cannot be null."));
        }
        if (galleryScriptVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScriptVersionName is required and cannot be null."));
        }
        String apiVersion = "2025-03-03";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), "2025-03-03", this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (galleryScriptName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScriptName is required and cannot be null."));
        }
        if (galleryScriptVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryScriptVersionName is required and cannot be null."));
        }
        String apiVersion = "2025-03-03";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), "2025-03-03", this.client.getSubscriptionId(), resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName) {
        return this.beginDeleteAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName) {
        return this.beginDeleteAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName) {
        this.deleteAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String galleryName, String galleryScriptName, String galleryScriptVersionName, Context context) {
        this.deleteAsync(resourceGroupName, galleryName, galleryScriptName, galleryScriptVersionName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryScriptVersionInner>> listByGalleryScriptNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByGalleryScriptNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GalleryScriptVersionList)res.getValue()).value(), ((GalleryScriptVersionList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryScriptVersionInner>> listByGalleryScriptNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByGalleryScriptNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GalleryScriptVersionList)res.getValue()).value(), ((GalleryScriptVersionList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ComputeManagementClientGalleryScriptVersions")
    public static interface GalleryScriptVersionsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/scripts/{galleryScriptName}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<GalleryScriptVersionList>> listByGalleryScript(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="galleryName") String var5, @PathParam(value="galleryScriptName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/scripts/{galleryScriptName}/versions/{galleryScriptVersionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<GalleryScriptVersionInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="galleryName") String var5, @PathParam(value="galleryScriptName") String var6, @PathParam(value="galleryScriptVersionName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/scripts/{galleryScriptName}/versions/{galleryScriptVersionName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="galleryName") String var5, @PathParam(value="galleryScriptName") String var6, @PathParam(value="galleryScriptVersionName") String var7, @BodyParam(value="application/json") GalleryScriptVersionInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/scripts/{galleryScriptName}/versions/{galleryScriptVersionName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="galleryName") String var5, @PathParam(value="galleryScriptName") String var6, @PathParam(value="galleryScriptVersionName") String var7, @BodyParam(value="application/json") GalleryScriptVersionUpdate var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/scripts/{galleryScriptName}/versions/{galleryScriptVersionName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="galleryName") String var5, @PathParam(value="galleryScriptName") String var6, @PathParam(value="galleryScriptVersionName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<GalleryScriptVersionList>> listByGalleryScriptNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

