// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineSizeInner;
import java.io.IOException;
import java.util.List;

/**
 * The List Virtual Machine operation response.
 */
@Fluent
public final class VirtualMachineSizeListResult implements JsonSerializable<VirtualMachineSizeListResult> {
    /*
     * The list of virtual machine sizes.
     */
    private List<VirtualMachineSizeInner> value;

    /*
     * The link to the next page of items.
     */
    private String nextLink;

    /**
     * Creates an instance of VirtualMachineSizeListResult class.
     */
    public VirtualMachineSizeListResult() {
    }

    /**
     * Get the value property: The list of virtual machine sizes.
     * 
     * @return the value value.
     */
    public List<VirtualMachineSizeInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of virtual machine sizes.
     * 
     * @param value the value value to set.
     * @return the VirtualMachineSizeListResult object itself.
     */
    public VirtualMachineSizeListResult withValue(List<VirtualMachineSizeInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The link to the next page of items.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The link to the next page of items.
     * 
     * @param nextLink the nextLink value to set.
     * @return the VirtualMachineSizeListResult object itself.
     */
    public VirtualMachineSizeListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachineSizeListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachineSizeListResult if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualMachineSizeListResult.
     */
    public static VirtualMachineSizeListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineSizeListResult deserializedVirtualMachineSizeListResult = new VirtualMachineSizeListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<VirtualMachineSizeInner> value
                        = reader.readArray(reader1 -> VirtualMachineSizeInner.fromJson(reader1));
                    deserializedVirtualMachineSizeListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedVirtualMachineSizeListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachineSizeListResult;
        });
    }
}
