// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes a virtual machines scale sets network configuration's DNS settings.
 */
@Fluent
public final class VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings
    implements JsonSerializable<VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings> {
    /*
     * The Domain name label.The concatenation of the domain name label and vm index will be the domain name labels of
     * the PublicIPAddress resources that will be created
     */
    private String domainNameLabel;

    /*
     * The Domain name label scope.The concatenation of the hashed domain name label that generated according to the
     * policy from domain name label scope and vm index will be the domain name labels of the PublicIPAddress resources
     * that will be created
     */
    private DomainNameLabelScopeTypes domainNameLabelScope;

    /**
     * Creates an instance of VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings class.
     */
    public VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings() {
    }

    /**
     * Get the domainNameLabel property: The Domain name label.The concatenation of the domain name label and vm index
     * will be the domain name labels of the PublicIPAddress resources that will be created.
     * 
     * @return the domainNameLabel value.
     */
    public String domainNameLabel() {
        return this.domainNameLabel;
    }

    /**
     * Set the domainNameLabel property: The Domain name label.The concatenation of the domain name label and vm index
     * will be the domain name labels of the PublicIPAddress resources that will be created.
     * 
     * @param domainNameLabel the domainNameLabel value to set.
     * @return the VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings object itself.
     */
    public VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings withDomainNameLabel(String domainNameLabel) {
        this.domainNameLabel = domainNameLabel;
        return this;
    }

    /**
     * Get the domainNameLabelScope property: The Domain name label scope.The concatenation of the hashed domain name
     * label that generated according to the policy from domain name label scope and vm index will be the domain name
     * labels of the PublicIPAddress resources that will be created.
     * 
     * @return the domainNameLabelScope value.
     */
    public DomainNameLabelScopeTypes domainNameLabelScope() {
        return this.domainNameLabelScope;
    }

    /**
     * Set the domainNameLabelScope property: The Domain name label scope.The concatenation of the hashed domain name
     * label that generated according to the policy from domain name label scope and vm index will be the domain name
     * labels of the PublicIPAddress resources that will be created.
     * 
     * @param domainNameLabelScope the domainNameLabelScope value to set.
     * @return the VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings object itself.
     */
    public VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings
        withDomainNameLabelScope(DomainNameLabelScopeTypes domainNameLabelScope) {
        this.domainNameLabelScope = domainNameLabelScope;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (domainNameLabel() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property domainNameLabel in model VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings"));
        }
    }

    private static final ClientLogger LOGGER
        = new ClientLogger(VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("domainNameLabel", this.domainNameLabel);
        jsonWriter.writeStringField("domainNameLabelScope",
            this.domainNameLabelScope == null ? null : this.domainNameLabelScope.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings if the JsonReader was
     * pointing to an instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the
     * VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings.
     */
    public static VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings deserializedVirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings
                = new VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("domainNameLabel".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings.domainNameLabel
                        = reader.getString();
                } else if ("domainNameLabelScope".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings.domainNameLabelScope
                        = DomainNameLabelScopeTypes.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings;
        });
    }
}
