// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineScaleSetExtensionInner;
import java.io.IOException;
import java.util.List;

/**
 * The List VM scale set extension operation response.
 */
@Fluent
public final class VirtualMachineScaleSetExtensionListResult
    implements JsonSerializable<VirtualMachineScaleSetExtensionListResult> {
    /*
     * The list of VM scale set extensions.
     */
    private List<VirtualMachineScaleSetExtensionInner> value;

    /*
     * The uri to fetch the next page of VM scale set extensions. Call ListNext() with this to fetch the next page of VM
     * scale set extensions.
     */
    private String nextLink;

    /**
     * Creates an instance of VirtualMachineScaleSetExtensionListResult class.
     */
    public VirtualMachineScaleSetExtensionListResult() {
    }

    /**
     * Get the value property: The list of VM scale set extensions.
     * 
     * @return the value value.
     */
    public List<VirtualMachineScaleSetExtensionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of VM scale set extensions.
     * 
     * @param value the value value to set.
     * @return the VirtualMachineScaleSetExtensionListResult object itself.
     */
    public VirtualMachineScaleSetExtensionListResult withValue(List<VirtualMachineScaleSetExtensionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The uri to fetch the next page of VM scale set extensions. Call ListNext() with this
     * to fetch the next page of VM scale set extensions.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The uri to fetch the next page of VM scale set extensions. Call ListNext() with this
     * to fetch the next page of VM scale set extensions.
     * 
     * @param nextLink the nextLink value to set.
     * @return the VirtualMachineScaleSetExtensionListResult object itself.
     */
    public VirtualMachineScaleSetExtensionListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property value in model VirtualMachineScaleSetExtensionListResult"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(VirtualMachineScaleSetExtensionListResult.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachineScaleSetExtensionListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachineScaleSetExtensionListResult if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VirtualMachineScaleSetExtensionListResult.
     */
    public static VirtualMachineScaleSetExtensionListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineScaleSetExtensionListResult deserializedVirtualMachineScaleSetExtensionListResult
                = new VirtualMachineScaleSetExtensionListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<VirtualMachineScaleSetExtensionInner> value
                        = reader.readArray(reader1 -> VirtualMachineScaleSetExtensionInner.fromJson(reader1));
                    deserializedVirtualMachineScaleSetExtensionListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetExtensionListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachineScaleSetExtensionListResult;
        });
    }
}
