// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * This is the validations profile of a Gallery Image Version.
 */
@Fluent
public final class ValidationsProfile implements JsonSerializable<ValidationsProfile> {
    /*
     * The published time of the image version
     */
    private String validationEtag;

    /*
     * The executedValidations property.
     */
    private List<ExecutedValidation> executedValidations;

    /*
     * This specifies the pub, offer, sku and version of the image version metadata
     */
    private List<PlatformAttribute> platformAttributes;

    /**
     * Creates an instance of ValidationsProfile class.
     */
    public ValidationsProfile() {
    }

    /**
     * Get the validationEtag property: The published time of the image version.
     * 
     * @return the validationEtag value.
     */
    public String validationEtag() {
        return this.validationEtag;
    }

    /**
     * Set the validationEtag property: The published time of the image version.
     * 
     * @param validationEtag the validationEtag value to set.
     * @return the ValidationsProfile object itself.
     */
    public ValidationsProfile withValidationEtag(String validationEtag) {
        this.validationEtag = validationEtag;
        return this;
    }

    /**
     * Get the executedValidations property: The executedValidations property.
     * 
     * @return the executedValidations value.
     */
    public List<ExecutedValidation> executedValidations() {
        return this.executedValidations;
    }

    /**
     * Set the executedValidations property: The executedValidations property.
     * 
     * @param executedValidations the executedValidations value to set.
     * @return the ValidationsProfile object itself.
     */
    public ValidationsProfile withExecutedValidations(List<ExecutedValidation> executedValidations) {
        this.executedValidations = executedValidations;
        return this;
    }

    /**
     * Get the platformAttributes property: This specifies the pub, offer, sku and version of the image version
     * metadata.
     * 
     * @return the platformAttributes value.
     */
    public List<PlatformAttribute> platformAttributes() {
        return this.platformAttributes;
    }

    /**
     * Set the platformAttributes property: This specifies the pub, offer, sku and version of the image version
     * metadata.
     * 
     * @param platformAttributes the platformAttributes value to set.
     * @return the ValidationsProfile object itself.
     */
    public ValidationsProfile withPlatformAttributes(List<PlatformAttribute> platformAttributes) {
        this.platformAttributes = platformAttributes;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (executedValidations() != null) {
            executedValidations().forEach(e -> e.validate());
        }
        if (platformAttributes() != null) {
            platformAttributes().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("validationEtag", this.validationEtag);
        jsonWriter.writeArrayField("executedValidations", this.executedValidations,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("platformAttributes", this.platformAttributes,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ValidationsProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ValidationsProfile if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ValidationsProfile.
     */
    public static ValidationsProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ValidationsProfile deserializedValidationsProfile = new ValidationsProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("validationEtag".equals(fieldName)) {
                    deserializedValidationsProfile.validationEtag = reader.getString();
                } else if ("executedValidations".equals(fieldName)) {
                    List<ExecutedValidation> executedValidations
                        = reader.readArray(reader1 -> ExecutedValidation.fromJson(reader1));
                    deserializedValidationsProfile.executedValidations = executedValidations;
                } else if ("platformAttributes".equals(fieldName)) {
                    List<PlatformAttribute> platformAttributes
                        = reader.readArray(reader1 -> PlatformAttribute.fromJson(reader1));
                    deserializedValidationsProfile.platformAttributes = platformAttributes;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedValidationsProfile;
        });
    }
}
