// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Additional settings for the VM app that contains the target package and config file name when it is deployed to
 * target VM or VM scale set.
 */
@Fluent
public final class UserArtifactSettings implements JsonSerializable<UserArtifactSettings> {
    /*
     * Optional. The name to assign the downloaded package file on the VM. This is limited to 4096 characters. If not
     * specified, the package file will be named the same as the Gallery Application name.
     */
    private String packageFileName;

    /*
     * Optional. The name to assign the downloaded config file on the VM. This is limited to 4096 characters. If not
     * specified, the config file will be named the Gallery Application name appended with "_config".
     */
    private String configFileName;

    /*
     * Optional. The action to be taken with regards to install/update/remove of the gallery application in the event of
     * a reboot.
     */
    private GalleryApplicationScriptRebootBehavior scriptBehaviorAfterReboot;

    /**
     * Creates an instance of UserArtifactSettings class.
     */
    public UserArtifactSettings() {
    }

    /**
     * Get the packageFileName property: Optional. The name to assign the downloaded package file on the VM. This is
     * limited to 4096 characters. If not specified, the package file will be named the same as the Gallery Application
     * name.
     * 
     * @return the packageFileName value.
     */
    public String packageFileName() {
        return this.packageFileName;
    }

    /**
     * Set the packageFileName property: Optional. The name to assign the downloaded package file on the VM. This is
     * limited to 4096 characters. If not specified, the package file will be named the same as the Gallery Application
     * name.
     * 
     * @param packageFileName the packageFileName value to set.
     * @return the UserArtifactSettings object itself.
     */
    public UserArtifactSettings withPackageFileName(String packageFileName) {
        this.packageFileName = packageFileName;
        return this;
    }

    /**
     * Get the configFileName property: Optional. The name to assign the downloaded config file on the VM. This is
     * limited to 4096 characters. If not specified, the config file will be named the Gallery Application name appended
     * with "_config".
     * 
     * @return the configFileName value.
     */
    public String configFileName() {
        return this.configFileName;
    }

    /**
     * Set the configFileName property: Optional. The name to assign the downloaded config file on the VM. This is
     * limited to 4096 characters. If not specified, the config file will be named the Gallery Application name appended
     * with "_config".
     * 
     * @param configFileName the configFileName value to set.
     * @return the UserArtifactSettings object itself.
     */
    public UserArtifactSettings withConfigFileName(String configFileName) {
        this.configFileName = configFileName;
        return this;
    }

    /**
     * Get the scriptBehaviorAfterReboot property: Optional. The action to be taken with regards to
     * install/update/remove of the gallery application in the event of a reboot.
     * 
     * @return the scriptBehaviorAfterReboot value.
     */
    public GalleryApplicationScriptRebootBehavior scriptBehaviorAfterReboot() {
        return this.scriptBehaviorAfterReboot;
    }

    /**
     * Set the scriptBehaviorAfterReboot property: Optional. The action to be taken with regards to
     * install/update/remove of the gallery application in the event of a reboot.
     * 
     * @param scriptBehaviorAfterReboot the scriptBehaviorAfterReboot value to set.
     * @return the UserArtifactSettings object itself.
     */
    public UserArtifactSettings
        withScriptBehaviorAfterReboot(GalleryApplicationScriptRebootBehavior scriptBehaviorAfterReboot) {
        this.scriptBehaviorAfterReboot = scriptBehaviorAfterReboot;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("packageFileName", this.packageFileName);
        jsonWriter.writeStringField("configFileName", this.configFileName);
        jsonWriter.writeStringField("scriptBehaviorAfterReboot",
            this.scriptBehaviorAfterReboot == null ? null : this.scriptBehaviorAfterReboot.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UserArtifactSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UserArtifactSettings if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the UserArtifactSettings.
     */
    public static UserArtifactSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UserArtifactSettings deserializedUserArtifactSettings = new UserArtifactSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("packageFileName".equals(fieldName)) {
                    deserializedUserArtifactSettings.packageFileName = reader.getString();
                } else if ("configFileName".equals(fieldName)) {
                    deserializedUserArtifactSettings.configFileName = reader.getString();
                } else if ("scriptBehaviorAfterReboot".equals(fieldName)) {
                    deserializedUserArtifactSettings.scriptBehaviorAfterReboot
                        = GalleryApplicationScriptRebootBehavior.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUserArtifactSettings;
        });
    }
}
