// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * The Update Resource model definition.
 */
@Fluent
public class UpdateResourceDefinition implements JsonSerializable<UpdateResourceDefinition> {
    /*
     * Resource Id
     */
    private String id;

    /*
     * Resource name
     */
    private String name;

    /*
     * Resource type
     */
    private String type;

    /*
     * Resource tags
     */
    private Map<String, String> tags;

    /**
     * Creates an instance of UpdateResourceDefinition class.
     */
    public UpdateResourceDefinition() {
    }

    /**
     * Get the id property: Resource Id.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Resource Id.
     * 
     * @param id the id value to set.
     * @return the UpdateResourceDefinition object itself.
     */
    UpdateResourceDefinition withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: Resource name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Resource name.
     * 
     * @param name the name value to set.
     * @return the UpdateResourceDefinition object itself.
     */
    UpdateResourceDefinition withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: Resource type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: Resource type.
     * 
     * @param type the type value to set.
     * @return the UpdateResourceDefinition object itself.
     */
    UpdateResourceDefinition withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the tags property: Resource tags.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Resource tags.
     * 
     * @param tags the tags value to set.
     * @return the UpdateResourceDefinition object itself.
     */
    public UpdateResourceDefinition withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UpdateResourceDefinition from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UpdateResourceDefinition if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the UpdateResourceDefinition.
     */
    public static UpdateResourceDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UpdateResourceDefinition deserializedUpdateResourceDefinition = new UpdateResourceDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedUpdateResourceDefinition.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedUpdateResourceDefinition.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedUpdateResourceDefinition.type = reader.getString();
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedUpdateResourceDefinition.tags = tags;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUpdateResourceDefinition;
        });
    }
}
