// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specifies the security settings like secure boot and vTPM used while creating the virtual machine. Minimum
 * api-version: 2020-12-01.
 */
@Fluent
public final class UefiSettings implements JsonSerializable<UefiSettings> {
    /*
     * Specifies whether secure boot should be enabled on the virtual machine. Minimum api-version: 2020-12-01.
     */
    private Boolean secureBootEnabled;

    /*
     * Specifies whether vTPM should be enabled on the virtual machine. Minimum api-version: 2020-12-01.
     */
    private Boolean vTpmEnabled;

    /**
     * Creates an instance of UefiSettings class.
     */
    public UefiSettings() {
    }

    /**
     * Get the secureBootEnabled property: Specifies whether secure boot should be enabled on the virtual machine.
     * Minimum api-version: 2020-12-01.
     * 
     * @return the secureBootEnabled value.
     */
    public Boolean secureBootEnabled() {
        return this.secureBootEnabled;
    }

    /**
     * Set the secureBootEnabled property: Specifies whether secure boot should be enabled on the virtual machine.
     * Minimum api-version: 2020-12-01.
     * 
     * @param secureBootEnabled the secureBootEnabled value to set.
     * @return the UefiSettings object itself.
     */
    public UefiSettings withSecureBootEnabled(Boolean secureBootEnabled) {
        this.secureBootEnabled = secureBootEnabled;
        return this;
    }

    /**
     * Get the vTpmEnabled property: Specifies whether vTPM should be enabled on the virtual machine. Minimum
     * api-version: 2020-12-01.
     * 
     * @return the vTpmEnabled value.
     */
    public Boolean vTpmEnabled() {
        return this.vTpmEnabled;
    }

    /**
     * Set the vTpmEnabled property: Specifies whether vTPM should be enabled on the virtual machine. Minimum
     * api-version: 2020-12-01.
     * 
     * @param vTpmEnabled the vTpmEnabled value to set.
     * @return the UefiSettings object itself.
     */
    public UefiSettings withVTpmEnabled(Boolean vTpmEnabled) {
        this.vTpmEnabled = vTpmEnabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("secureBootEnabled", this.secureBootEnabled);
        jsonWriter.writeBooleanField("vTpmEnabled", this.vTpmEnabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UefiSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UefiSettings if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the UefiSettings.
     */
    public static UefiSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UefiSettings deserializedUefiSettings = new UefiSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("secureBootEnabled".equals(fieldName)) {
                    deserializedUefiSettings.secureBootEnabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("vTpmEnabled".equals(fieldName)) {
                    deserializedUefiSettings.vTpmEnabled = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUefiSettings;
        });
    }
}
