// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The TerminateNotificationProfile model.
 */
@Fluent
public final class TerminateNotificationProfile implements JsonSerializable<TerminateNotificationProfile> {
    /*
     * Configurable length of time a Virtual Machine being deleted will have to potentially approve the Terminate
     * Scheduled Event before the event is auto approved (timed out). The configuration must be specified in ISO 8601
     * format, the default value is 5 minutes (PT5M)
     */
    private String notBeforeTimeout;

    /*
     * Specifies whether the Terminate Scheduled event is enabled or disabled.
     */
    private Boolean enable;

    /**
     * Creates an instance of TerminateNotificationProfile class.
     */
    public TerminateNotificationProfile() {
    }

    /**
     * Get the notBeforeTimeout property: Configurable length of time a Virtual Machine being deleted will have to
     * potentially approve the Terminate Scheduled Event before the event is auto approved (timed out). The
     * configuration must be specified in ISO 8601 format, the default value is 5 minutes (PT5M).
     * 
     * @return the notBeforeTimeout value.
     */
    public String notBeforeTimeout() {
        return this.notBeforeTimeout;
    }

    /**
     * Set the notBeforeTimeout property: Configurable length of time a Virtual Machine being deleted will have to
     * potentially approve the Terminate Scheduled Event before the event is auto approved (timed out). The
     * configuration must be specified in ISO 8601 format, the default value is 5 minutes (PT5M).
     * 
     * @param notBeforeTimeout the notBeforeTimeout value to set.
     * @return the TerminateNotificationProfile object itself.
     */
    public TerminateNotificationProfile withNotBeforeTimeout(String notBeforeTimeout) {
        this.notBeforeTimeout = notBeforeTimeout;
        return this;
    }

    /**
     * Get the enable property: Specifies whether the Terminate Scheduled event is enabled or disabled.
     * 
     * @return the enable value.
     */
    public Boolean enable() {
        return this.enable;
    }

    /**
     * Set the enable property: Specifies whether the Terminate Scheduled event is enabled or disabled.
     * 
     * @param enable the enable value to set.
     * @return the TerminateNotificationProfile object itself.
     */
    public TerminateNotificationProfile withEnable(Boolean enable) {
        this.enable = enable;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("notBeforeTimeout", this.notBeforeTimeout);
        jsonWriter.writeBooleanField("enable", this.enable);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TerminateNotificationProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TerminateNotificationProfile if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the TerminateNotificationProfile.
     */
    public static TerminateNotificationProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TerminateNotificationProfile deserializedTerminateNotificationProfile = new TerminateNotificationProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("notBeforeTimeout".equals(fieldName)) {
                    deserializedTerminateNotificationProfile.notBeforeTimeout = reader.getString();
                } else if ("enable".equals(fieldName)) {
                    deserializedTerminateNotificationProfile.enable = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTerminateNotificationProfile;
        });
    }
}
