// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Specifies the strategy to be used when selecting the storage account type. Cannot be specified along with
 * storageAccountType, but can be overridden per region by specifying targetRegions[].storageAccountType. This property
 * is not updatable.
 */
public final class StorageAccountStrategy extends ExpandableStringEnum<StorageAccountStrategy> {
    /**
     * Static value PreferStandard_ZRS for StorageAccountStrategy.
     */
    public static final StorageAccountStrategy PREFER_STANDARD_ZRS = fromString("PreferStandard_ZRS");

    /**
     * Static value DefaultStandard_LRS for StorageAccountStrategy.
     */
    public static final StorageAccountStrategy DEFAULT_STANDARD_LRS = fromString("DefaultStandard_LRS");

    /**
     * Creates a new instance of StorageAccountStrategy value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public StorageAccountStrategy() {
    }

    /**
     * Creates or finds a StorageAccountStrategy from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding StorageAccountStrategy.
     */
    public static StorageAccountStrategy fromString(String name) {
        return fromString(name, StorageAccountStrategy.class);
    }

    /**
     * Gets known StorageAccountStrategy values.
     * 
     * @return known StorageAccountStrategy values.
     */
    public static Collection<StorageAccountStrategy> values() {
        return values(StorageAccountStrategy.class);
    }
}
