// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Contains information about SSH certificate public key and the path on the Linux VM where the public key is placed.
 */
@Fluent
public final class SshPublicKey implements JsonSerializable<SshPublicKey> {
    /*
     * Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the
     * specified key is appended to the file. Example: /home/user/.ssh/authorized_keys
     */
    private String path;

    /*
     * SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit
     * and in ssh-rsa format. For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in
     * Azure]https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
     */
    private String keyData;

    /**
     * Creates an instance of SshPublicKey class.
     */
    public SshPublicKey() {
    }

    /**
     * Get the path property: Specifies the full path on the created VM where ssh public key is stored. If the file
     * already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys.
     * 
     * @return the path value.
     */
    public String path() {
        return this.path;
    }

    /**
     * Set the path property: Specifies the full path on the created VM where ssh public key is stored. If the file
     * already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys.
     * 
     * @param path the path value to set.
     * @return the SshPublicKey object itself.
     */
    public SshPublicKey withPath(String path) {
        this.path = path;
        return this;
    }

    /**
     * Get the keyData property: SSH public key certificate used to authenticate with the VM through ssh. The key needs
     * to be at least 2048-bit and in ssh-rsa format. For creating ssh keys, see [Create SSH keys on Linux and Mac for
     * Linux VMs in Azure]https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
     * 
     * @return the keyData value.
     */
    public String keyData() {
        return this.keyData;
    }

    /**
     * Set the keyData property: SSH public key certificate used to authenticate with the VM through ssh. The key needs
     * to be at least 2048-bit and in ssh-rsa format. For creating ssh keys, see [Create SSH keys on Linux and Mac for
     * Linux VMs in Azure]https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
     * 
     * @param keyData the keyData value to set.
     * @return the SshPublicKey object itself.
     */
    public SshPublicKey withKeyData(String keyData) {
        this.keyData = keyData;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeStringField("keyData", this.keyData);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SshPublicKey from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SshPublicKey if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SshPublicKey.
     */
    public static SshPublicKey fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SshPublicKey deserializedSshPublicKey = new SshPublicKey();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("path".equals(fieldName)) {
                    deserializedSshPublicKey.path = reader.getString();
                } else if ("keyData".equals(fieldName)) {
                    deserializedSshPublicKey.keyData = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSshPublicKey;
        });
    }
}
