// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The source script from which the Script Version is going to be created.
 */
@Fluent
public final class ScriptSource implements JsonSerializable<ScriptSource> {
    /*
     * Required. The link of the source script, it must be a readable storage blob with SAS URI or publicly accessible
     * URI or managed identity enabled.
     */
    private String scriptLink;

    /*
     * Optional. Any input parameters that needs to passed to the script and are accessed within the script for its
     * execution.
     */
    private List<GalleryScriptParameter> parameters;

    /**
     * Creates an instance of ScriptSource class.
     */
    public ScriptSource() {
    }

    /**
     * Get the scriptLink property: Required. The link of the source script, it must be a readable storage blob with SAS
     * URI or publicly accessible URI or managed identity enabled.
     * 
     * @return the scriptLink value.
     */
    public String scriptLink() {
        return this.scriptLink;
    }

    /**
     * Set the scriptLink property: Required. The link of the source script, it must be a readable storage blob with SAS
     * URI or publicly accessible URI or managed identity enabled.
     * 
     * @param scriptLink the scriptLink value to set.
     * @return the ScriptSource object itself.
     */
    public ScriptSource withScriptLink(String scriptLink) {
        this.scriptLink = scriptLink;
        return this;
    }

    /**
     * Get the parameters property: Optional. Any input parameters that needs to passed to the script and are accessed
     * within the script for its execution.
     * 
     * @return the parameters value.
     */
    public List<GalleryScriptParameter> parameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: Optional. Any input parameters that needs to passed to the script and are accessed
     * within the script for its execution.
     * 
     * @param parameters the parameters value to set.
     * @return the ScriptSource object itself.
     */
    public ScriptSource withParameters(List<GalleryScriptParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (scriptLink() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property scriptLink in model ScriptSource"));
        }
        if (parameters() != null) {
            parameters().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ScriptSource.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scriptLink", this.scriptLink);
        jsonWriter.writeArrayField("parameters", this.parameters, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ScriptSource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ScriptSource if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ScriptSource.
     */
    public static ScriptSource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ScriptSource deserializedScriptSource = new ScriptSource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("scriptLink".equals(fieldName)) {
                    deserializedScriptSource.scriptLink = reader.getString();
                } else if ("parameters".equals(fieldName)) {
                    List<GalleryScriptParameter> parameters
                        = reader.readArray(reader1 -> GalleryScriptParameter.fromJson(reader1));
                    deserializedScriptSource.parameters = parameters;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedScriptSource;
        });
    }
}
