// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes the properties of a run command parameter.
 */
@Fluent
public final class RunCommandParameterDefinition implements JsonSerializable<RunCommandParameterDefinition> {
    /*
     * The run command parameter name.
     */
    private String name;

    /*
     * The run command parameter type.
     */
    private String type;

    /*
     * The run command parameter default value.
     */
    private String defaultValue;

    /*
     * The run command parameter required.
     */
    private Boolean required;

    /**
     * Creates an instance of RunCommandParameterDefinition class.
     */
    public RunCommandParameterDefinition() {
    }

    /**
     * Get the name property: The run command parameter name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The run command parameter name.
     * 
     * @param name the name value to set.
     * @return the RunCommandParameterDefinition object itself.
     */
    public RunCommandParameterDefinition withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: The run command parameter type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: The run command parameter type.
     * 
     * @param type the type value to set.
     * @return the RunCommandParameterDefinition object itself.
     */
    public RunCommandParameterDefinition withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the defaultValue property: The run command parameter default value.
     * 
     * @return the defaultValue value.
     */
    public String defaultValue() {
        return this.defaultValue;
    }

    /**
     * Set the defaultValue property: The run command parameter default value.
     * 
     * @param defaultValue the defaultValue value to set.
     * @return the RunCommandParameterDefinition object itself.
     */
    public RunCommandParameterDefinition withDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    /**
     * Get the required property: The run command parameter required.
     * 
     * @return the required value.
     */
    public Boolean required() {
        return this.required;
    }

    /**
     * Set the required property: The run command parameter required.
     * 
     * @param required the required value to set.
     * @return the RunCommandParameterDefinition object itself.
     */
    public RunCommandParameterDefinition withRequired(Boolean required) {
        this.required = required;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property name in model RunCommandParameterDefinition"));
        }
        if (type() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property type in model RunCommandParameterDefinition"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RunCommandParameterDefinition.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("defaultValue", this.defaultValue);
        jsonWriter.writeBooleanField("required", this.required);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RunCommandParameterDefinition from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RunCommandParameterDefinition if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RunCommandParameterDefinition.
     */
    public static RunCommandParameterDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RunCommandParameterDefinition deserializedRunCommandParameterDefinition
                = new RunCommandParameterDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedRunCommandParameterDefinition.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedRunCommandParameterDefinition.type = reader.getString();
                } else if ("defaultValue".equals(fieldName)) {
                    deserializedRunCommandParameterDefinition.defaultValue = reader.getString();
                } else if ("required".equals(fieldName)) {
                    deserializedRunCommandParameterDefinition.required = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRunCommandParameterDefinition;
        });
    }
}
