// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Capture Virtual Machine parameters.
 */
@Fluent
public final class RunCommandInput implements JsonSerializable<RunCommandInput> {
    /*
     * Specifies a commandId of predefined built-in script. Command IDs available for Linux are listed at
     * https://aka.ms/RunCommandManagedLinux#available-commands, Windows at
     * https://aka.ms/RunCommandManagedWindows#available-commands.
     */
    private String commandId;

    /*
     * Optional. The script to be executed. When this value is given, the given script will override the default script
     * of the command.
     */
    private List<String> script;

    /*
     * The run command parameters.
     */
    private List<RunCommandInputParameter> parameters;

    /**
     * Creates an instance of RunCommandInput class.
     */
    public RunCommandInput() {
    }

    /**
     * Get the commandId property: Specifies a commandId of predefined built-in script. Command IDs available for Linux
     * are listed at https://aka.ms/RunCommandManagedLinux#available-commands, Windows at
     * https://aka.ms/RunCommandManagedWindows#available-commands.
     * 
     * @return the commandId value.
     */
    public String commandId() {
        return this.commandId;
    }

    /**
     * Set the commandId property: Specifies a commandId of predefined built-in script. Command IDs available for Linux
     * are listed at https://aka.ms/RunCommandManagedLinux#available-commands, Windows at
     * https://aka.ms/RunCommandManagedWindows#available-commands.
     * 
     * @param commandId the commandId value to set.
     * @return the RunCommandInput object itself.
     */
    public RunCommandInput withCommandId(String commandId) {
        this.commandId = commandId;
        return this;
    }

    /**
     * Get the script property: Optional. The script to be executed. When this value is given, the given script will
     * override the default script of the command.
     * 
     * @return the script value.
     */
    public List<String> script() {
        return this.script;
    }

    /**
     * Set the script property: Optional. The script to be executed. When this value is given, the given script will
     * override the default script of the command.
     * 
     * @param script the script value to set.
     * @return the RunCommandInput object itself.
     */
    public RunCommandInput withScript(List<String> script) {
        this.script = script;
        return this;
    }

    /**
     * Get the parameters property: The run command parameters.
     * 
     * @return the parameters value.
     */
    public List<RunCommandInputParameter> parameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: The run command parameters.
     * 
     * @param parameters the parameters value to set.
     * @return the RunCommandInput object itself.
     */
    public RunCommandInput withParameters(List<RunCommandInputParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (commandId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property commandId in model RunCommandInput"));
        }
        if (parameters() != null) {
            parameters().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RunCommandInput.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("commandId", this.commandId);
        jsonWriter.writeArrayField("script", this.script, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("parameters", this.parameters, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RunCommandInput from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RunCommandInput if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RunCommandInput.
     */
    public static RunCommandInput fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RunCommandInput deserializedRunCommandInput = new RunCommandInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("commandId".equals(fieldName)) {
                    deserializedRunCommandInput.commandId = reader.getString();
                } else if ("script".equals(fieldName)) {
                    List<String> script = reader.readArray(reader1 -> reader1.getString());
                    deserializedRunCommandInput.script = script;
                } else if ("parameters".equals(fieldName)) {
                    List<RunCommandInputParameter> parameters
                        = reader.readArray(reader1 -> RunCommandInputParameter.fromJson(reader1));
                    deserializedRunCommandInput.parameters = parameters;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRunCommandInput;
        });
    }
}
