// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Specifies a list of role instances from the cloud service.
 */
@Fluent
public final class RoleInstances implements JsonSerializable<RoleInstances> {
    /*
     * List of cloud service role instance names. Value of '*' will signify all role instances of the cloud service.
     */
    private List<String> roleInstances;

    /**
     * Creates an instance of RoleInstances class.
     */
    public RoleInstances() {
    }

    /**
     * Get the roleInstances property: List of cloud service role instance names. Value of '*' will signify all role
     * instances of the cloud service.
     * 
     * @return the roleInstances value.
     */
    public List<String> roleInstances() {
        return this.roleInstances;
    }

    /**
     * Set the roleInstances property: List of cloud service role instance names. Value of '*' will signify all role
     * instances of the cloud service.
     * 
     * @param roleInstances the roleInstances value to set.
     * @return the RoleInstances object itself.
     */
    public RoleInstances withRoleInstances(List<String> roleInstances) {
        this.roleInstances = roleInstances;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (roleInstances() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property roleInstances in model RoleInstances"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RoleInstances.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("roleInstances", this.roleInstances,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RoleInstances from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RoleInstances if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RoleInstances.
     */
    public static RoleInstances fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RoleInstances deserializedRoleInstances = new RoleInstances();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("roleInstances".equals(fieldName)) {
                    List<String> roleInstances = reader.readArray(reader1 -> reader1.getString());
                    deserializedRoleInstances.roleInstances = roleInstances;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRoleInstances;
        });
    }
}
