// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.RestorePointCollectionProperties;
import com.azure.resourcemanager.compute.fluent.models.RestorePointInner;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Update Restore Point collection parameters.
 */
@Fluent
public final class RestorePointCollectionUpdate extends UpdateResource {
    /*
     * The restore point collection properties.
     */
    private RestorePointCollectionProperties innerProperties;

    /**
     * Creates an instance of RestorePointCollectionUpdate class.
     */
    public RestorePointCollectionUpdate() {
    }

    /**
     * Get the innerProperties property: The restore point collection properties.
     * 
     * @return the innerProperties value.
     */
    private RestorePointCollectionProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RestorePointCollectionUpdate withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the source property: The properties of the source resource that this restore point collection is created
     * from.
     * 
     * @return the source value.
     */
    public RestorePointCollectionSourceProperties source() {
        return this.innerProperties() == null ? null : this.innerProperties().source();
    }

    /**
     * Set the source property: The properties of the source resource that this restore point collection is created
     * from.
     * 
     * @param source the source value to set.
     * @return the RestorePointCollectionUpdate object itself.
     */
    public RestorePointCollectionUpdate withSource(RestorePointCollectionSourceProperties source) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RestorePointCollectionProperties();
        }
        this.innerProperties().withSource(source);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the restore point collection.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the restorePointCollectionId property: The unique id of the restore point collection.
     * 
     * @return the restorePointCollectionId value.
     */
    public String restorePointCollectionId() {
        return this.innerProperties() == null ? null : this.innerProperties().restorePointCollectionId();
    }

    /**
     * Get the restorePoints property: A list containing all restore points created under this restore point collection.
     * 
     * @return the restorePoints value.
     */
    public List<RestorePointInner> restorePoints() {
        return this.innerProperties() == null ? null : this.innerProperties().restorePoints();
    }

    /**
     * Get the instantAccess property: This property determines whether instant access snapshot is enabled for restore
     * points created under this restore point collection for Premium SSD v2 or Ultra disk. Instant access snapshot for
     * Premium SSD v2 or Ultra disk is instantaneously available for restoring disk with fast restore performance.
     * 
     * @return the instantAccess value.
     */
    public Boolean instantAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().instantAccess();
    }

    /**
     * Set the instantAccess property: This property determines whether instant access snapshot is enabled for restore
     * points created under this restore point collection for Premium SSD v2 or Ultra disk. Instant access snapshot for
     * Premium SSD v2 or Ultra disk is instantaneously available for restoring disk with fast restore performance.
     * 
     * @param instantAccess the instantAccess value to set.
     * @return the RestorePointCollectionUpdate object itself.
     */
    public RestorePointCollectionUpdate withInstantAccess(Boolean instantAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RestorePointCollectionProperties();
        }
        this.innerProperties().withInstantAccess(instantAccess);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RestorePointCollectionUpdate from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RestorePointCollectionUpdate if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RestorePointCollectionUpdate.
     */
    public static RestorePointCollectionUpdate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RestorePointCollectionUpdate deserializedRestorePointCollectionUpdate = new RestorePointCollectionUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedRestorePointCollectionUpdate.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedRestorePointCollectionUpdate.innerProperties
                        = RestorePointCollectionProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRestorePointCollectionUpdate;
        });
    }
}
