// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Indicates the type of capacity reservation. Allowed values are 'Block' for block capacity reservations and 'Targeted'
 * for reservations that enable a VM to consume a specific capacity reservation when a capacity reservation group is
 * provided. The reservation type is immutable and cannot be changed after it is assigned.
 */
public final class ReservationType extends ExpandableStringEnum<ReservationType> {
    /**
     * Static value Targeted for ReservationType.
     */
    public static final ReservationType TARGETED = fromString("Targeted");

    /**
     * Static value Block for ReservationType.
     */
    public static final ReservationType BLOCK = fromString("Block");

    /**
     * Creates a new instance of ReservationType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ReservationType() {
    }

    /**
     * Creates or finds a ReservationType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ReservationType.
     */
    public static ReservationType fromString(String name) {
        return fromString(name, ReservationType.class);
    }

    /**
     * Gets known ReservationType values.
     * 
     * @return known ReservationType values.
     */
    public static Collection<ReservationType> values() {
        return values(ReservationType.class);
    }
}
