// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

/**
 * Specifies the protocol of WinRM listener. Possible values are: **http,** **https.**.
 */
public enum ProtocolTypes {
    /**
     * Enum value Http.
     */
    HTTP("Http"),

    /**
     * Enum value Https.
     */
    HTTPS("Https");

    /**
     * The actual serialized value for a ProtocolTypes instance.
     */
    private final String value;

    ProtocolTypes(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ProtocolTypes instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed ProtocolTypes object, or null if unable to parse.
     */
    public static ProtocolTypes fromString(String value) {
        if (value == null) {
            return null;
        }
        ProtocolTypes[] items = ProtocolTypes.values();
        for (ProtocolTypes item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
