// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Information about a specific patch that was encountered during an installation action.
 */
@Immutable
public final class PatchInstallationDetail implements JsonSerializable<PatchInstallationDetail> {
    /*
     * A unique identifier for the patch.
     */
    private String patchId;

    /*
     * The friendly name of the patch.
     */
    private String name;

    /*
     * The version string of the package. It may conform to Semantic Versioning. Only applies to Linux.
     */
    private String version;

    /*
     * The KBID of the patch. Only applies to Windows patches.
     */
    private String kbId;

    /*
     * The classification(s) of the patch as provided by the patch publisher.
     */
    private List<String> classifications;

    /*
     * The state of the patch after the installation operation completed.
     */
    private PatchInstallationState installationState;

    /**
     * Creates an instance of PatchInstallationDetail class.
     */
    public PatchInstallationDetail() {
    }

    /**
     * Get the patchId property: A unique identifier for the patch.
     * 
     * @return the patchId value.
     */
    public String patchId() {
        return this.patchId;
    }

    /**
     * Get the name property: The friendly name of the patch.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the version property: The version string of the package. It may conform to Semantic Versioning. Only applies
     * to Linux.
     * 
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Get the kbId property: The KBID of the patch. Only applies to Windows patches.
     * 
     * @return the kbId value.
     */
    public String kbId() {
        return this.kbId;
    }

    /**
     * Get the classifications property: The classification(s) of the patch as provided by the patch publisher.
     * 
     * @return the classifications value.
     */
    public List<String> classifications() {
        return this.classifications;
    }

    /**
     * Get the installationState property: The state of the patch after the installation operation completed.
     * 
     * @return the installationState value.
     */
    public PatchInstallationState installationState() {
        return this.installationState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PatchInstallationDetail from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PatchInstallationDetail if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PatchInstallationDetail.
     */
    public static PatchInstallationDetail fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PatchInstallationDetail deserializedPatchInstallationDetail = new PatchInstallationDetail();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("patchId".equals(fieldName)) {
                    deserializedPatchInstallationDetail.patchId = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedPatchInstallationDetail.name = reader.getString();
                } else if ("version".equals(fieldName)) {
                    deserializedPatchInstallationDetail.version = reader.getString();
                } else if ("kbId".equals(fieldName)) {
                    deserializedPatchInstallationDetail.kbId = reader.getString();
                } else if ("classifications".equals(fieldName)) {
                    List<String> classifications = reader.readArray(reader1 -> reader1.getString());
                    deserializedPatchInstallationDetail.classifications = classifications;
                } else if ("installationState".equals(fieldName)) {
                    deserializedPatchInstallationDetail.installationState
                        = PatchInstallationState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPatchInstallationDetail;
        });
    }
}
