// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The input of virtual machine migration from Availability Set to Flexible Virtual Machine Scale Set.
 */
@Fluent
public final class MigrateVMToVirtualMachineScaleSetInput
    implements JsonSerializable<MigrateVMToVirtualMachineScaleSetInput> {
    /*
     * The target zone of VM migration to Flexible Virtual Machine Scale Set.
     */
    private String targetZone;

    /*
     * The target compute fault domain of VM migration to Flexible Virtual Machine Scale Set.
     */
    private Integer targetFaultDomain;

    /*
     * The target Virtual Machine size of VM migration to Flexible Virtual Machine Scale Set.
     */
    private String targetVMSize;

    /**
     * Creates an instance of MigrateVMToVirtualMachineScaleSetInput class.
     */
    public MigrateVMToVirtualMachineScaleSetInput() {
    }

    /**
     * Get the targetZone property: The target zone of VM migration to Flexible Virtual Machine Scale Set.
     * 
     * @return the targetZone value.
     */
    public String targetZone() {
        return this.targetZone;
    }

    /**
     * Set the targetZone property: The target zone of VM migration to Flexible Virtual Machine Scale Set.
     * 
     * @param targetZone the targetZone value to set.
     * @return the MigrateVMToVirtualMachineScaleSetInput object itself.
     */
    public MigrateVMToVirtualMachineScaleSetInput withTargetZone(String targetZone) {
        this.targetZone = targetZone;
        return this;
    }

    /**
     * Get the targetFaultDomain property: The target compute fault domain of VM migration to Flexible Virtual Machine
     * Scale Set.
     * 
     * @return the targetFaultDomain value.
     */
    public Integer targetFaultDomain() {
        return this.targetFaultDomain;
    }

    /**
     * Set the targetFaultDomain property: The target compute fault domain of VM migration to Flexible Virtual Machine
     * Scale Set.
     * 
     * @param targetFaultDomain the targetFaultDomain value to set.
     * @return the MigrateVMToVirtualMachineScaleSetInput object itself.
     */
    public MigrateVMToVirtualMachineScaleSetInput withTargetFaultDomain(Integer targetFaultDomain) {
        this.targetFaultDomain = targetFaultDomain;
        return this;
    }

    /**
     * Get the targetVMSize property: The target Virtual Machine size of VM migration to Flexible Virtual Machine Scale
     * Set.
     * 
     * @return the targetVMSize value.
     */
    public String targetVMSize() {
        return this.targetVMSize;
    }

    /**
     * Set the targetVMSize property: The target Virtual Machine size of VM migration to Flexible Virtual Machine Scale
     * Set.
     * 
     * @param targetVMSize the targetVMSize value to set.
     * @return the MigrateVMToVirtualMachineScaleSetInput object itself.
     */
    public MigrateVMToVirtualMachineScaleSetInput withTargetVMSize(String targetVMSize) {
        this.targetVMSize = targetVMSize;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetZone", this.targetZone);
        jsonWriter.writeNumberField("targetFaultDomain", this.targetFaultDomain);
        jsonWriter.writeStringField("targetVMSize", this.targetVMSize);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MigrateVMToVirtualMachineScaleSetInput from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MigrateVMToVirtualMachineScaleSetInput if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MigrateVMToVirtualMachineScaleSetInput.
     */
    public static MigrateVMToVirtualMachineScaleSetInput fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MigrateVMToVirtualMachineScaleSetInput deserializedMigrateVMToVirtualMachineScaleSetInput
                = new MigrateVMToVirtualMachineScaleSetInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("targetZone".equals(fieldName)) {
                    deserializedMigrateVMToVirtualMachineScaleSetInput.targetZone = reader.getString();
                } else if ("targetFaultDomain".equals(fieldName)) {
                    deserializedMigrateVMToVirtualMachineScaleSetInput.targetFaultDomain
                        = reader.getNullable(JsonReader::getInt);
                } else if ("targetVMSize".equals(fieldName)) {
                    deserializedMigrateVMToVirtualMachineScaleSetInput.targetVMSize = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMigrateVMToVirtualMachineScaleSetInput;
        });
    }
}
