// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The configuration parameters used to limit the number of virtual machines per availability zone in the virtual
 * machine scale set.
 */
@Fluent
public final class MaxInstancePercentPerZonePolicy implements JsonSerializable<MaxInstancePercentPerZonePolicy> {
    /*
     * Specifies whether maxInstancePercentPerZonePolicy should be enabled on the virtual machine scale set.
     */
    private Boolean enabled;

    /*
     * Limit on the number of instances in each zone as a percentage of the total capacity of the virtual machine scale
     * set.
     */
    private Integer value;

    /**
     * Creates an instance of MaxInstancePercentPerZonePolicy class.
     */
    public MaxInstancePercentPerZonePolicy() {
    }

    /**
     * Get the enabled property: Specifies whether maxInstancePercentPerZonePolicy should be enabled on the virtual
     * machine scale set.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Specifies whether maxInstancePercentPerZonePolicy should be enabled on the virtual
     * machine scale set.
     * 
     * @param enabled the enabled value to set.
     * @return the MaxInstancePercentPerZonePolicy object itself.
     */
    public MaxInstancePercentPerZonePolicy withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the value property: Limit on the number of instances in each zone as a percentage of the total capacity of
     * the virtual machine scale set.
     * 
     * @return the value value.
     */
    public Integer value() {
        return this.value;
    }

    /**
     * Set the value property: Limit on the number of instances in each zone as a percentage of the total capacity of
     * the virtual machine scale set.
     * 
     * @param value the value value to set.
     * @return the MaxInstancePercentPerZonePolicy object itself.
     */
    public MaxInstancePercentPerZonePolicy withValue(Integer value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeNumberField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MaxInstancePercentPerZonePolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MaxInstancePercentPerZonePolicy if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MaxInstancePercentPerZonePolicy.
     */
    public static MaxInstancePercentPerZonePolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MaxInstancePercentPerZonePolicy deserializedMaxInstancePercentPerZonePolicy
                = new MaxInstancePercentPerZonePolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedMaxInstancePercentPerZonePolicy.enabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("value".equals(fieldName)) {
                    deserializedMaxInstancePercentPerZonePolicy.value = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMaxInstancePercentPerZonePolicy;
        });
    }
}
