// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Maintenance Operation Status.
 */
@Fluent
public final class MaintenanceRedeployStatus implements JsonSerializable<MaintenanceRedeployStatus> {
    /*
     * True, if customer is allowed to perform Maintenance.
     */
    private Boolean isCustomerInitiatedMaintenanceAllowed;

    /*
     * Start Time for the Pre Maintenance Window.
     */
    private OffsetDateTime preMaintenanceWindowStartTime;

    /*
     * End Time for the Pre Maintenance Window.
     */
    private OffsetDateTime preMaintenanceWindowEndTime;

    /*
     * Start Time for the Maintenance Window.
     */
    private OffsetDateTime maintenanceWindowStartTime;

    /*
     * End Time for the Maintenance Window.
     */
    private OffsetDateTime maintenanceWindowEndTime;

    /*
     * The Last Maintenance Operation Result Code.
     */
    private MaintenanceOperationResultCodeTypes lastOperationResultCode;

    /*
     * Message returned for the last Maintenance Operation.
     */
    private String lastOperationMessage;

    /**
     * Creates an instance of MaintenanceRedeployStatus class.
     */
    public MaintenanceRedeployStatus() {
    }

    /**
     * Get the isCustomerInitiatedMaintenanceAllowed property: True, if customer is allowed to perform Maintenance.
     * 
     * @return the isCustomerInitiatedMaintenanceAllowed value.
     */
    public Boolean isCustomerInitiatedMaintenanceAllowed() {
        return this.isCustomerInitiatedMaintenanceAllowed;
    }

    /**
     * Set the isCustomerInitiatedMaintenanceAllowed property: True, if customer is allowed to perform Maintenance.
     * 
     * @param isCustomerInitiatedMaintenanceAllowed the isCustomerInitiatedMaintenanceAllowed value to set.
     * @return the MaintenanceRedeployStatus object itself.
     */
    public MaintenanceRedeployStatus
        withIsCustomerInitiatedMaintenanceAllowed(Boolean isCustomerInitiatedMaintenanceAllowed) {
        this.isCustomerInitiatedMaintenanceAllowed = isCustomerInitiatedMaintenanceAllowed;
        return this;
    }

    /**
     * Get the preMaintenanceWindowStartTime property: Start Time for the Pre Maintenance Window.
     * 
     * @return the preMaintenanceWindowStartTime value.
     */
    public OffsetDateTime preMaintenanceWindowStartTime() {
        return this.preMaintenanceWindowStartTime;
    }

    /**
     * Set the preMaintenanceWindowStartTime property: Start Time for the Pre Maintenance Window.
     * 
     * @param preMaintenanceWindowStartTime the preMaintenanceWindowStartTime value to set.
     * @return the MaintenanceRedeployStatus object itself.
     */
    public MaintenanceRedeployStatus withPreMaintenanceWindowStartTime(OffsetDateTime preMaintenanceWindowStartTime) {
        this.preMaintenanceWindowStartTime = preMaintenanceWindowStartTime;
        return this;
    }

    /**
     * Get the preMaintenanceWindowEndTime property: End Time for the Pre Maintenance Window.
     * 
     * @return the preMaintenanceWindowEndTime value.
     */
    public OffsetDateTime preMaintenanceWindowEndTime() {
        return this.preMaintenanceWindowEndTime;
    }

    /**
     * Set the preMaintenanceWindowEndTime property: End Time for the Pre Maintenance Window.
     * 
     * @param preMaintenanceWindowEndTime the preMaintenanceWindowEndTime value to set.
     * @return the MaintenanceRedeployStatus object itself.
     */
    public MaintenanceRedeployStatus withPreMaintenanceWindowEndTime(OffsetDateTime preMaintenanceWindowEndTime) {
        this.preMaintenanceWindowEndTime = preMaintenanceWindowEndTime;
        return this;
    }

    /**
     * Get the maintenanceWindowStartTime property: Start Time for the Maintenance Window.
     * 
     * @return the maintenanceWindowStartTime value.
     */
    public OffsetDateTime maintenanceWindowStartTime() {
        return this.maintenanceWindowStartTime;
    }

    /**
     * Set the maintenanceWindowStartTime property: Start Time for the Maintenance Window.
     * 
     * @param maintenanceWindowStartTime the maintenanceWindowStartTime value to set.
     * @return the MaintenanceRedeployStatus object itself.
     */
    public MaintenanceRedeployStatus withMaintenanceWindowStartTime(OffsetDateTime maintenanceWindowStartTime) {
        this.maintenanceWindowStartTime = maintenanceWindowStartTime;
        return this;
    }

    /**
     * Get the maintenanceWindowEndTime property: End Time for the Maintenance Window.
     * 
     * @return the maintenanceWindowEndTime value.
     */
    public OffsetDateTime maintenanceWindowEndTime() {
        return this.maintenanceWindowEndTime;
    }

    /**
     * Set the maintenanceWindowEndTime property: End Time for the Maintenance Window.
     * 
     * @param maintenanceWindowEndTime the maintenanceWindowEndTime value to set.
     * @return the MaintenanceRedeployStatus object itself.
     */
    public MaintenanceRedeployStatus withMaintenanceWindowEndTime(OffsetDateTime maintenanceWindowEndTime) {
        this.maintenanceWindowEndTime = maintenanceWindowEndTime;
        return this;
    }

    /**
     * Get the lastOperationResultCode property: The Last Maintenance Operation Result Code.
     * 
     * @return the lastOperationResultCode value.
     */
    public MaintenanceOperationResultCodeTypes lastOperationResultCode() {
        return this.lastOperationResultCode;
    }

    /**
     * Set the lastOperationResultCode property: The Last Maintenance Operation Result Code.
     * 
     * @param lastOperationResultCode the lastOperationResultCode value to set.
     * @return the MaintenanceRedeployStatus object itself.
     */
    public MaintenanceRedeployStatus
        withLastOperationResultCode(MaintenanceOperationResultCodeTypes lastOperationResultCode) {
        this.lastOperationResultCode = lastOperationResultCode;
        return this;
    }

    /**
     * Get the lastOperationMessage property: Message returned for the last Maintenance Operation.
     * 
     * @return the lastOperationMessage value.
     */
    public String lastOperationMessage() {
        return this.lastOperationMessage;
    }

    /**
     * Set the lastOperationMessage property: Message returned for the last Maintenance Operation.
     * 
     * @param lastOperationMessage the lastOperationMessage value to set.
     * @return the MaintenanceRedeployStatus object itself.
     */
    public MaintenanceRedeployStatus withLastOperationMessage(String lastOperationMessage) {
        this.lastOperationMessage = lastOperationMessage;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isCustomerInitiatedMaintenanceAllowed",
            this.isCustomerInitiatedMaintenanceAllowed);
        jsonWriter.writeStringField("preMaintenanceWindowStartTime",
            this.preMaintenanceWindowStartTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.preMaintenanceWindowStartTime));
        jsonWriter.writeStringField("preMaintenanceWindowEndTime",
            this.preMaintenanceWindowEndTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.preMaintenanceWindowEndTime));
        jsonWriter.writeStringField("maintenanceWindowStartTime",
            this.maintenanceWindowStartTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.maintenanceWindowStartTime));
        jsonWriter.writeStringField("maintenanceWindowEndTime",
            this.maintenanceWindowEndTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.maintenanceWindowEndTime));
        jsonWriter.writeStringField("lastOperationResultCode",
            this.lastOperationResultCode == null ? null : this.lastOperationResultCode.toString());
        jsonWriter.writeStringField("lastOperationMessage", this.lastOperationMessage);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MaintenanceRedeployStatus from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MaintenanceRedeployStatus if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MaintenanceRedeployStatus.
     */
    public static MaintenanceRedeployStatus fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MaintenanceRedeployStatus deserializedMaintenanceRedeployStatus = new MaintenanceRedeployStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("isCustomerInitiatedMaintenanceAllowed".equals(fieldName)) {
                    deserializedMaintenanceRedeployStatus.isCustomerInitiatedMaintenanceAllowed
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("preMaintenanceWindowStartTime".equals(fieldName)) {
                    deserializedMaintenanceRedeployStatus.preMaintenanceWindowStartTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("preMaintenanceWindowEndTime".equals(fieldName)) {
                    deserializedMaintenanceRedeployStatus.preMaintenanceWindowEndTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("maintenanceWindowStartTime".equals(fieldName)) {
                    deserializedMaintenanceRedeployStatus.maintenanceWindowStartTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("maintenanceWindowEndTime".equals(fieldName)) {
                    deserializedMaintenanceRedeployStatus.maintenanceWindowEndTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("lastOperationResultCode".equals(fieldName)) {
                    deserializedMaintenanceRedeployStatus.lastOperationResultCode
                        = MaintenanceOperationResultCodeTypes.fromString(reader.getString());
                } else if ("lastOperationMessage".equals(fieldName)) {
                    deserializedMaintenanceRedeployStatus.lastOperationMessage = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMaintenanceRedeployStatus;
        });
    }
}
