// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Key Vault Key Url and vault id of KeK, KeK is optional and when provided is used to unwrap the encryptionKey.
 */
@Fluent
public final class KeyVaultAndKeyReference implements JsonSerializable<KeyVaultAndKeyReference> {
    /*
     * Resource id of the KeyVault containing the key or secret
     */
    private SourceVault sourceVault;

    /*
     * Url pointing to a key or secret in KeyVault
     */
    private String keyUrl;

    /**
     * Creates an instance of KeyVaultAndKeyReference class.
     */
    public KeyVaultAndKeyReference() {
    }

    /**
     * Get the sourceVault property: Resource id of the KeyVault containing the key or secret.
     * 
     * @return the sourceVault value.
     */
    public SourceVault sourceVault() {
        return this.sourceVault;
    }

    /**
     * Set the sourceVault property: Resource id of the KeyVault containing the key or secret.
     * 
     * @param sourceVault the sourceVault value to set.
     * @return the KeyVaultAndKeyReference object itself.
     */
    public KeyVaultAndKeyReference withSourceVault(SourceVault sourceVault) {
        this.sourceVault = sourceVault;
        return this;
    }

    /**
     * Get the keyUrl property: Url pointing to a key or secret in KeyVault.
     * 
     * @return the keyUrl value.
     */
    public String keyUrl() {
        return this.keyUrl;
    }

    /**
     * Set the keyUrl property: Url pointing to a key or secret in KeyVault.
     * 
     * @param keyUrl the keyUrl value to set.
     * @return the KeyVaultAndKeyReference object itself.
     */
    public KeyVaultAndKeyReference withKeyUrl(String keyUrl) {
        this.keyUrl = keyUrl;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sourceVault() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property sourceVault in model KeyVaultAndKeyReference"));
        } else {
            sourceVault().validate();
        }
        if (keyUrl() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property keyUrl in model KeyVaultAndKeyReference"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultAndKeyReference.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sourceVault", this.sourceVault);
        jsonWriter.writeStringField("keyUrl", this.keyUrl);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyVaultAndKeyReference from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyVaultAndKeyReference if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KeyVaultAndKeyReference.
     */
    public static KeyVaultAndKeyReference fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyVaultAndKeyReference deserializedKeyVaultAndKeyReference = new KeyVaultAndKeyReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sourceVault".equals(fieldName)) {
                    deserializedKeyVaultAndKeyReference.sourceVault = SourceVault.fromJson(reader);
                } else if ("keyUrl".equals(fieldName)) {
                    deserializedKeyVaultAndKeyReference.keyUrl = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyVaultAndKeyReference;
        });
    }
}
