// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Inner error details.
 */
@Fluent
public final class InnerError implements JsonSerializable<InnerError> {
    /*
     * The exception type.
     */
    private String exceptiontype;

    /*
     * The internal error message or exception dump.
     */
    private String errordetail;

    /**
     * Creates an instance of InnerError class.
     */
    public InnerError() {
    }

    /**
     * Get the exceptiontype property: The exception type.
     * 
     * @return the exceptiontype value.
     */
    public String exceptiontype() {
        return this.exceptiontype;
    }

    /**
     * Set the exceptiontype property: The exception type.
     * 
     * @param exceptiontype the exceptiontype value to set.
     * @return the InnerError object itself.
     */
    public InnerError withExceptiontype(String exceptiontype) {
        this.exceptiontype = exceptiontype;
        return this;
    }

    /**
     * Get the errordetail property: The internal error message or exception dump.
     * 
     * @return the errordetail value.
     */
    public String errordetail() {
        return this.errordetail;
    }

    /**
     * Set the errordetail property: The internal error message or exception dump.
     * 
     * @param errordetail the errordetail value to set.
     * @return the InnerError object itself.
     */
    public InnerError withErrordetail(String errordetail) {
        this.errordetail = errordetail;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("exceptiontype", this.exceptiontype);
        jsonWriter.writeStringField("errordetail", this.errordetail);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of InnerError from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of InnerError if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the InnerError.
     */
    public static InnerError fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            InnerError deserializedInnerError = new InnerError();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("exceptiontype".equals(fieldName)) {
                    deserializedInnerError.exceptiontype = reader.getString();
                } else if ("errordetail".equals(fieldName)) {
                    deserializedInnerError.errordetail = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedInnerError;
        });
    }
}
