// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes the gallery image definition purchase plan. This is used by marketplace images.
 */
@Fluent
public final class ImagePurchasePlan implements JsonSerializable<ImagePurchasePlan> {
    /*
     * The plan ID.
     */
    private String name;

    /*
     * The publisher ID.
     */
    private String publisher;

    /*
     * The product ID.
     */
    private String product;

    /**
     * Creates an instance of ImagePurchasePlan class.
     */
    public ImagePurchasePlan() {
    }

    /**
     * Get the name property: The plan ID.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The plan ID.
     * 
     * @param name the name value to set.
     * @return the ImagePurchasePlan object itself.
     */
    public ImagePurchasePlan withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the publisher property: The publisher ID.
     * 
     * @return the publisher value.
     */
    public String publisher() {
        return this.publisher;
    }

    /**
     * Set the publisher property: The publisher ID.
     * 
     * @param publisher the publisher value to set.
     * @return the ImagePurchasePlan object itself.
     */
    public ImagePurchasePlan withPublisher(String publisher) {
        this.publisher = publisher;
        return this;
    }

    /**
     * Get the product property: The product ID.
     * 
     * @return the product value.
     */
    public String product() {
        return this.product;
    }

    /**
     * Set the product property: The product ID.
     * 
     * @param product the product value to set.
     * @return the ImagePurchasePlan object itself.
     */
    public ImagePurchasePlan withProduct(String product) {
        this.product = product;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("publisher", this.publisher);
        jsonWriter.writeStringField("product", this.product);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ImagePurchasePlan from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ImagePurchasePlan if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ImagePurchasePlan.
     */
    public static ImagePurchasePlan fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ImagePurchasePlan deserializedImagePurchasePlan = new ImagePurchasePlan();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedImagePurchasePlan.name = reader.getString();
                } else if ("publisher".equals(fieldName)) {
                    deserializedImagePurchasePlan.publisher = reader.getString();
                } else if ("product".equals(fieldName)) {
                    deserializedImagePurchasePlan.product = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedImagePurchasePlan;
        });
    }
}
