// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specifies particular host endpoint settings.
 */
@Fluent
public final class HostEndpointSettings implements JsonSerializable<HostEndpointSettings> {
    /*
     * Specifies the execution mode. In Audit mode, the system acts as if it is enforcing the access control policy,
     * including emitting access denial entries in the logs but it does not actually deny any requests to host
     * endpoints. In Enforce mode, the system will enforce the access control and it is the recommended mode of
     * operation.
     */
    private Modes mode;

    /*
     * Specifies the InVMAccessControlProfileVersion resource id in the format of
     * /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{
     * galleryName}/inVMAccessControlProfiles/{profile}/versions/{version}
     */
    private String inVMAccessControlProfileReferenceId;

    /**
     * Creates an instance of HostEndpointSettings class.
     */
    public HostEndpointSettings() {
    }

    /**
     * Get the mode property: Specifies the execution mode. In Audit mode, the system acts as if it is enforcing the
     * access control policy, including emitting access denial entries in the logs but it does not actually deny any
     * requests to host endpoints. In Enforce mode, the system will enforce the access control and it is the recommended
     * mode of operation.
     * 
     * @return the mode value.
     */
    public Modes mode() {
        return this.mode;
    }

    /**
     * Set the mode property: Specifies the execution mode. In Audit mode, the system acts as if it is enforcing the
     * access control policy, including emitting access denial entries in the logs but it does not actually deny any
     * requests to host endpoints. In Enforce mode, the system will enforce the access control and it is the recommended
     * mode of operation.
     * 
     * @param mode the mode value to set.
     * @return the HostEndpointSettings object itself.
     */
    public HostEndpointSettings withMode(Modes mode) {
        this.mode = mode;
        return this;
    }

    /**
     * Get the inVMAccessControlProfileReferenceId property: Specifies the InVMAccessControlProfileVersion resource id
     * in the format of
     * /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/inVMAccessControlProfiles/{profile}/versions/{version}.
     * 
     * @return the inVMAccessControlProfileReferenceId value.
     */
    public String inVMAccessControlProfileReferenceId() {
        return this.inVMAccessControlProfileReferenceId;
    }

    /**
     * Set the inVMAccessControlProfileReferenceId property: Specifies the InVMAccessControlProfileVersion resource id
     * in the format of
     * /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/inVMAccessControlProfiles/{profile}/versions/{version}.
     * 
     * @param inVMAccessControlProfileReferenceId the inVMAccessControlProfileReferenceId value to set.
     * @return the HostEndpointSettings object itself.
     */
    public HostEndpointSettings withInVMAccessControlProfileReferenceId(String inVMAccessControlProfileReferenceId) {
        this.inVMAccessControlProfileReferenceId = inVMAccessControlProfileReferenceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        jsonWriter.writeStringField("inVMAccessControlProfileReferenceId", this.inVMAccessControlProfileReferenceId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HostEndpointSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HostEndpointSettings if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the HostEndpointSettings.
     */
    public static HostEndpointSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HostEndpointSettings deserializedHostEndpointSettings = new HostEndpointSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("mode".equals(fieldName)) {
                    deserializedHostEndpointSettings.mode = Modes.fromString(reader.getString());
                } else if ("inVMAccessControlProfileReferenceId".equals(fieldName)) {
                    deserializedHostEndpointSettings.inVMAccessControlProfileReferenceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHostEndpointSettings;
        });
    }
}
