// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The definition of a generic gallery parameter.
 */
@Fluent
public class GenericGalleryParameter implements JsonSerializable<GenericGalleryParameter> {
    /*
     * The name of the parameter.
     */
    private String name;

    /*
     * Indicates whether this parameter must be passed.
     */
    private Boolean required;

    /*
     * The default value of the parameter, only applies to string types.
     */
    private String defaultValue;

    /*
     * A description to help users understand what this parameter means
     */
    private String description;

    /**
     * Creates an instance of GenericGalleryParameter class.
     */
    public GenericGalleryParameter() {
    }

    /**
     * Get the name property: The name of the parameter.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the parameter.
     * 
     * @param name the name value to set.
     * @return the GenericGalleryParameter object itself.
     */
    public GenericGalleryParameter withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the required property: Indicates whether this parameter must be passed.
     * 
     * @return the required value.
     */
    public Boolean required() {
        return this.required;
    }

    /**
     * Set the required property: Indicates whether this parameter must be passed.
     * 
     * @param required the required value to set.
     * @return the GenericGalleryParameter object itself.
     */
    public GenericGalleryParameter withRequired(Boolean required) {
        this.required = required;
        return this;
    }

    /**
     * Get the defaultValue property: The default value of the parameter, only applies to string types.
     * 
     * @return the defaultValue value.
     */
    public String defaultValue() {
        return this.defaultValue;
    }

    /**
     * Set the defaultValue property: The default value of the parameter, only applies to string types.
     * 
     * @param defaultValue the defaultValue value to set.
     * @return the GenericGalleryParameter object itself.
     */
    public GenericGalleryParameter withDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    /**
     * Get the description property: A description to help users understand what this parameter means.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: A description to help users understand what this parameter means.
     * 
     * @param description the description value to set.
     * @return the GenericGalleryParameter object itself.
     */
    public GenericGalleryParameter withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model GenericGalleryParameter"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GenericGalleryParameter.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeBooleanField("required", this.required);
        jsonWriter.writeStringField("defaultValue", this.defaultValue);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GenericGalleryParameter from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GenericGalleryParameter if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GenericGalleryParameter.
     */
    public static GenericGalleryParameter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GenericGalleryParameter deserializedGenericGalleryParameter = new GenericGalleryParameter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedGenericGalleryParameter.name = reader.getString();
                } else if ("required".equals(fieldName)) {
                    deserializedGenericGalleryParameter.required = reader.getNullable(JsonReader::getBoolean);
                } else if ("defaultValue".equals(fieldName)) {
                    deserializedGenericGalleryParameter.defaultValue = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedGenericGalleryParameter.description = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGenericGalleryParameter;
        });
    }
}
