// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.GalleryScriptVersionProperties;
import java.io.IOException;
import java.util.Map;

/**
 * Specifies information about the gallery Script Version that you want to update.
 */
@Fluent
public final class GalleryScriptVersionUpdate extends UpdateResourceDefinition {
    /*
     * Gallery script version properties to update.
     */
    private GalleryScriptVersionProperties innerProperties;

    /*
     * Resource type
     */
    private String type;

    /*
     * Resource name
     */
    private String name;

    /*
     * Resource Id
     */
    private String id;

    /**
     * Creates an instance of GalleryScriptVersionUpdate class.
     */
    public GalleryScriptVersionUpdate() {
    }

    /**
     * Get the innerProperties property: Gallery script version properties to update.
     * 
     * @return the innerProperties value.
     */
    private GalleryScriptVersionProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: Resource type.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: Resource name.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Resource Id.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GalleryScriptVersionUpdate withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the publishingProfile property: The publishing profile of a gallery image version.
     * 
     * @return the publishingProfile value.
     */
    public GalleryScriptVersionPublishingProfile publishingProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().publishingProfile();
    }

    /**
     * Set the publishingProfile property: The publishing profile of a gallery image version.
     * 
     * @param publishingProfile the publishingProfile value to set.
     * @return the GalleryScriptVersionUpdate object itself.
     */
    public GalleryScriptVersionUpdate withPublishingProfile(GalleryScriptVersionPublishingProfile publishingProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryScriptVersionProperties();
        }
        this.innerProperties().withPublishingProfile(publishingProfile);
        return this;
    }

    /**
     * Get the safetyProfile property: The safety profile of the Gallery Script Version.
     * 
     * @return the safetyProfile value.
     */
    public GalleryScriptVersionSafetyProfile safetyProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().safetyProfile();
    }

    /**
     * Set the safetyProfile property: The safety profile of the Gallery Script Version.
     * 
     * @param safetyProfile the safetyProfile value to set.
     * @return the GalleryScriptVersionUpdate object itself.
     */
    public GalleryScriptVersionUpdate withSafetyProfile(GalleryScriptVersionSafetyProfile safetyProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryScriptVersionProperties();
        }
        this.innerProperties().withSafetyProfile(safetyProfile);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state, which only appears in the response.
     * 
     * @return the provisioningState value.
     */
    public GalleryProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the replicationStatus property: This is the replication status of the gallery image version.
     * 
     * @return the replicationStatus value.
     */
    public ReplicationStatus replicationStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().replicationStatus();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GalleryScriptVersionUpdate from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GalleryScriptVersionUpdate if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GalleryScriptVersionUpdate.
     */
    public static GalleryScriptVersionUpdate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryScriptVersionUpdate deserializedGalleryScriptVersionUpdate = new GalleryScriptVersionUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedGalleryScriptVersionUpdate.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedGalleryScriptVersionUpdate.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedGalleryScriptVersionUpdate.type = reader.getString();
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedGalleryScriptVersionUpdate.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedGalleryScriptVersionUpdate.innerProperties
                        = GalleryScriptVersionProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGalleryScriptVersionUpdate;
        });
    }
}
