// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * The publishing profile of a gallery image version.
 */
@Fluent
public final class GalleryScriptVersionPublishingProfile extends GalleryArtifactPublishingProfileBase {
    /*
     * The source script from which the Script Version is going to be created.
     */
    private ScriptSource source;

    /*
     * The timestamp for when the gallery image version is published.
     */
    private OffsetDateTime publishedDate;

    /**
     * Creates an instance of GalleryScriptVersionPublishingProfile class.
     */
    public GalleryScriptVersionPublishingProfile() {
    }

    /**
     * Get the source property: The source script from which the Script Version is going to be created.
     * 
     * @return the source value.
     */
    public ScriptSource source() {
        return this.source;
    }

    /**
     * Set the source property: The source script from which the Script Version is going to be created.
     * 
     * @param source the source value to set.
     * @return the GalleryScriptVersionPublishingProfile object itself.
     */
    public GalleryScriptVersionPublishingProfile withSource(ScriptSource source) {
        this.source = source;
        return this;
    }

    /**
     * Get the publishedDate property: The timestamp for when the gallery image version is published.
     * 
     * @return the publishedDate value.
     */
    @Override
    public OffsetDateTime publishedDate() {
        return this.publishedDate;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GalleryScriptVersionPublishingProfile withTargetRegions(List<TargetRegion> targetRegions) {
        super.withTargetRegions(targetRegions);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GalleryScriptVersionPublishingProfile withReplicaCount(Integer replicaCount) {
        super.withReplicaCount(replicaCount);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GalleryScriptVersionPublishingProfile withExcludeFromLatest(Boolean excludeFromLatest) {
        super.withExcludeFromLatest(excludeFromLatest);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GalleryScriptVersionPublishingProfile withEndOfLifeDate(OffsetDateTime endOfLifeDate) {
        super.withEndOfLifeDate(endOfLifeDate);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GalleryScriptVersionPublishingProfile withStorageAccountType(StorageAccountType storageAccountType) {
        super.withStorageAccountType(storageAccountType);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GalleryScriptVersionPublishingProfile withReplicationMode(ReplicationMode replicationMode) {
        super.withReplicationMode(replicationMode);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GalleryScriptVersionPublishingProfile
        withTargetExtendedLocations(List<GalleryTargetExtendedLocation> targetExtendedLocations) {
        super.withTargetExtendedLocations(targetExtendedLocations);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GalleryScriptVersionPublishingProfile
        withStorageAccountStrategy(StorageAccountStrategy storageAccountStrategy) {
        super.withStorageAccountStrategy(storageAccountStrategy);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (source() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property source in model GalleryScriptVersionPublishingProfile"));
        } else {
            source().validate();
        }
        if (targetRegions() != null) {
            targetRegions().forEach(e -> e.validate());
        }
        if (targetExtendedLocations() != null) {
            targetExtendedLocations().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GalleryScriptVersionPublishingProfile.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("targetRegions", targetRegions(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeNumberField("replicaCount", replicaCount());
        jsonWriter.writeBooleanField("excludeFromLatest", excludeFromLatest());
        jsonWriter.writeStringField("endOfLifeDate",
            endOfLifeDate() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(endOfLifeDate()));
        jsonWriter.writeStringField("storageAccountType",
            storageAccountType() == null ? null : storageAccountType().toString());
        jsonWriter.writeStringField("replicationMode", replicationMode() == null ? null : replicationMode().toString());
        jsonWriter.writeArrayField("targetExtendedLocations", targetExtendedLocations(),
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("storageAccountStrategy",
            storageAccountStrategy() == null ? null : storageAccountStrategy().toString());
        jsonWriter.writeJsonField("source", this.source);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GalleryScriptVersionPublishingProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GalleryScriptVersionPublishingProfile if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GalleryScriptVersionPublishingProfile.
     */
    public static GalleryScriptVersionPublishingProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryScriptVersionPublishingProfile deserializedGalleryScriptVersionPublishingProfile
                = new GalleryScriptVersionPublishingProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("targetRegions".equals(fieldName)) {
                    List<TargetRegion> targetRegions = reader.readArray(reader1 -> TargetRegion.fromJson(reader1));
                    deserializedGalleryScriptVersionPublishingProfile.withTargetRegions(targetRegions);
                } else if ("replicaCount".equals(fieldName)) {
                    deserializedGalleryScriptVersionPublishingProfile
                        .withReplicaCount(reader.getNullable(JsonReader::getInt));
                } else if ("excludeFromLatest".equals(fieldName)) {
                    deserializedGalleryScriptVersionPublishingProfile
                        .withExcludeFromLatest(reader.getNullable(JsonReader::getBoolean));
                } else if ("publishedDate".equals(fieldName)) {
                    deserializedGalleryScriptVersionPublishingProfile.publishedDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("endOfLifeDate".equals(fieldName)) {
                    deserializedGalleryScriptVersionPublishingProfile.withEndOfLifeDate(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("storageAccountType".equals(fieldName)) {
                    deserializedGalleryScriptVersionPublishingProfile
                        .withStorageAccountType(StorageAccountType.fromString(reader.getString()));
                } else if ("replicationMode".equals(fieldName)) {
                    deserializedGalleryScriptVersionPublishingProfile
                        .withReplicationMode(ReplicationMode.fromString(reader.getString()));
                } else if ("targetExtendedLocations".equals(fieldName)) {
                    List<GalleryTargetExtendedLocation> targetExtendedLocations
                        = reader.readArray(reader1 -> GalleryTargetExtendedLocation.fromJson(reader1));
                    deserializedGalleryScriptVersionPublishingProfile
                        .withTargetExtendedLocations(targetExtendedLocations);
                } else if ("storageAccountStrategy".equals(fieldName)) {
                    deserializedGalleryScriptVersionPublishingProfile
                        .withStorageAccountStrategy(StorageAccountStrategy.fromString(reader.getString()));
                } else if ("source".equals(fieldName)) {
                    deserializedGalleryScriptVersionPublishingProfile.source = ScriptSource.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGalleryScriptVersionPublishingProfile;
        });
    }
}
