// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Specifies the type of the Gallery Script parameter. Possible values are: String, Int, Double, Boolean, Enum.
 */
public final class GalleryScriptParameterType extends ExpandableStringEnum<GalleryScriptParameterType> {
    /**
     * Static value String for GalleryScriptParameterType.
     */
    public static final GalleryScriptParameterType STRING = fromString("String");

    /**
     * Static value Int for GalleryScriptParameterType.
     */
    public static final GalleryScriptParameterType INT = fromString("Int");

    /**
     * Static value Double for GalleryScriptParameterType.
     */
    public static final GalleryScriptParameterType DOUBLE = fromString("Double");

    /**
     * Static value Boolean for GalleryScriptParameterType.
     */
    public static final GalleryScriptParameterType BOOLEAN = fromString("Boolean");

    /**
     * Static value Enum for GalleryScriptParameterType.
     */
    public static final GalleryScriptParameterType ENUM = fromString("Enum");

    /**
     * Creates a new instance of GalleryScriptParameterType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public GalleryScriptParameterType() {
    }

    /**
     * Creates or finds a GalleryScriptParameterType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding GalleryScriptParameterType.
     */
    public static GalleryScriptParameterType fromString(String name) {
        return fromString(name, GalleryScriptParameterType.class);
    }

    /**
     * Gets known GalleryScriptParameterType values.
     * 
     * @return known GalleryScriptParameterType values.
     */
    public static Collection<GalleryScriptParameterType> values() {
        return values(GalleryScriptParameterType.class);
    }
}
