// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The definition of a parameter that can be passed to a script of a Gallery Script Version.
 */
@Fluent
public final class GalleryScriptParameter extends GenericGalleryParameter {
    /*
     * Specifies the type of the Gallery Script parameter. Possible values are: String, Int, Double, Boolean, Enum
     */
    private GalleryScriptParameterType type;

    /*
     * The minimum value of parameter.
     */
    private String minValue;

    /*
     * The minimum value of parameter.
     */
    private String maxValue;

    /*
     * A list of permissible values. Only applicable values are from 'enum' values defined in 'GalleryScriptParameter'.
     */
    private List<String> enumValues;

    /**
     * Creates an instance of GalleryScriptParameter class.
     */
    public GalleryScriptParameter() {
    }

    /**
     * Get the type property: Specifies the type of the Gallery Script parameter. Possible values are: String, Int,
     * Double, Boolean, Enum.
     * 
     * @return the type value.
     */
    public GalleryScriptParameterType type() {
        return this.type;
    }

    /**
     * Set the type property: Specifies the type of the Gallery Script parameter. Possible values are: String, Int,
     * Double, Boolean, Enum.
     * 
     * @param type the type value to set.
     * @return the GalleryScriptParameter object itself.
     */
    public GalleryScriptParameter withType(GalleryScriptParameterType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the minValue property: The minimum value of parameter.
     * 
     * @return the minValue value.
     */
    public String minValue() {
        return this.minValue;
    }

    /**
     * Set the minValue property: The minimum value of parameter.
     * 
     * @param minValue the minValue value to set.
     * @return the GalleryScriptParameter object itself.
     */
    public GalleryScriptParameter withMinValue(String minValue) {
        this.minValue = minValue;
        return this;
    }

    /**
     * Get the maxValue property: The minimum value of parameter.
     * 
     * @return the maxValue value.
     */
    public String maxValue() {
        return this.maxValue;
    }

    /**
     * Set the maxValue property: The minimum value of parameter.
     * 
     * @param maxValue the maxValue value to set.
     * @return the GalleryScriptParameter object itself.
     */
    public GalleryScriptParameter withMaxValue(String maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    /**
     * Get the enumValues property: A list of permissible values. Only applicable values are from 'enum' values defined
     * in 'GalleryScriptParameter'.
     * 
     * @return the enumValues value.
     */
    public List<String> enumValues() {
        return this.enumValues;
    }

    /**
     * Set the enumValues property: A list of permissible values. Only applicable values are from 'enum' values defined
     * in 'GalleryScriptParameter'.
     * 
     * @param enumValues the enumValues value to set.
     * @return the GalleryScriptParameter object itself.
     */
    public GalleryScriptParameter withEnumValues(List<String> enumValues) {
        this.enumValues = enumValues;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GalleryScriptParameter withName(String name) {
        super.withName(name);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GalleryScriptParameter withRequired(Boolean required) {
        super.withRequired(required);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GalleryScriptParameter withDefaultValue(String defaultValue) {
        super.withDefaultValue(defaultValue);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GalleryScriptParameter withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model GalleryScriptParameter"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GalleryScriptParameter.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", name());
        jsonWriter.writeBooleanField("required", required());
        jsonWriter.writeStringField("defaultValue", defaultValue());
        jsonWriter.writeStringField("description", description());
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("minValue", this.minValue);
        jsonWriter.writeStringField("maxValue", this.maxValue);
        jsonWriter.writeArrayField("enumValues", this.enumValues, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GalleryScriptParameter from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GalleryScriptParameter if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GalleryScriptParameter.
     */
    public static GalleryScriptParameter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryScriptParameter deserializedGalleryScriptParameter = new GalleryScriptParameter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedGalleryScriptParameter.withName(reader.getString());
                } else if ("required".equals(fieldName)) {
                    deserializedGalleryScriptParameter.withRequired(reader.getNullable(JsonReader::getBoolean));
                } else if ("defaultValue".equals(fieldName)) {
                    deserializedGalleryScriptParameter.withDefaultValue(reader.getString());
                } else if ("description".equals(fieldName)) {
                    deserializedGalleryScriptParameter.withDescription(reader.getString());
                } else if ("type".equals(fieldName)) {
                    deserializedGalleryScriptParameter.type = GalleryScriptParameterType.fromString(reader.getString());
                } else if ("minValue".equals(fieldName)) {
                    deserializedGalleryScriptParameter.minValue = reader.getString();
                } else if ("maxValue".equals(fieldName)) {
                    deserializedGalleryScriptParameter.maxValue = reader.getString();
                } else if ("enumValues".equals(fieldName)) {
                    List<String> enumValues = reader.readArray(reader1 -> reader1.getString());
                    deserializedGalleryScriptParameter.enumValues = enumValues;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGalleryScriptParameter;
        });
    }
}
