// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.GalleryInVMAccessControlProfileVersionProperties;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

/**
 * Specifies information about the gallery inVMAccessControlProfile version that you want to update.
 */
@Fluent
public final class GalleryInVMAccessControlProfileVersionUpdate extends UpdateResourceDefinition {
    /*
     * Describes the properties of an inVMAccessControlProfile version.
     */
    private GalleryInVMAccessControlProfileVersionProperties innerProperties;

    /*
     * Resource type
     */
    private String type;

    /*
     * Resource name
     */
    private String name;

    /*
     * Resource Id
     */
    private String id;

    /**
     * Creates an instance of GalleryInVMAccessControlProfileVersionUpdate class.
     */
    public GalleryInVMAccessControlProfileVersionUpdate() {
    }

    /**
     * Get the innerProperties property: Describes the properties of an inVMAccessControlProfile version.
     * 
     * @return the innerProperties value.
     */
    private GalleryInVMAccessControlProfileVersionProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: Resource type.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: Resource name.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Resource Id.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GalleryInVMAccessControlProfileVersionUpdate withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the mode property: This property allows you to specify whether the access control rules are in Audit mode, in
     * Enforce mode or Disabled. Possible values are: 'Audit', 'Enforce' or 'Disabled'.
     * 
     * @return the mode value.
     */
    public AccessControlRulesMode mode() {
        return this.innerProperties() == null ? null : this.innerProperties().mode();
    }

    /**
     * Set the mode property: This property allows you to specify whether the access control rules are in Audit mode, in
     * Enforce mode or Disabled. Possible values are: 'Audit', 'Enforce' or 'Disabled'.
     * 
     * @param mode the mode value to set.
     * @return the GalleryInVMAccessControlProfileVersionUpdate object itself.
     */
    public GalleryInVMAccessControlProfileVersionUpdate withMode(AccessControlRulesMode mode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryInVMAccessControlProfileVersionProperties();
        }
        this.innerProperties().withMode(mode);
        return this;
    }

    /**
     * Get the defaultAccess property: This property allows you to specify if the requests will be allowed to access the
     * host endpoints. Possible values are: 'Allow', 'Deny'.
     * 
     * @return the defaultAccess value.
     */
    public EndpointAccess defaultAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultAccess();
    }

    /**
     * Set the defaultAccess property: This property allows you to specify if the requests will be allowed to access the
     * host endpoints. Possible values are: 'Allow', 'Deny'.
     * 
     * @param defaultAccess the defaultAccess value to set.
     * @return the GalleryInVMAccessControlProfileVersionUpdate object itself.
     */
    public GalleryInVMAccessControlProfileVersionUpdate withDefaultAccess(EndpointAccess defaultAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryInVMAccessControlProfileVersionProperties();
        }
        this.innerProperties().withDefaultAccess(defaultAccess);
        return this;
    }

    /**
     * Get the rules property: This is the Access Control Rules specification for an inVMAccessControlProfile version.
     * 
     * @return the rules value.
     */
    public AccessControlRules rules() {
        return this.innerProperties() == null ? null : this.innerProperties().rules();
    }

    /**
     * Set the rules property: This is the Access Control Rules specification for an inVMAccessControlProfile version.
     * 
     * @param rules the rules value to set.
     * @return the GalleryInVMAccessControlProfileVersionUpdate object itself.
     */
    public GalleryInVMAccessControlProfileVersionUpdate withRules(AccessControlRules rules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryInVMAccessControlProfileVersionProperties();
        }
        this.innerProperties().withRules(rules);
        return this;
    }

    /**
     * Get the targetLocations property: The target regions where the Resource Profile version is going to be replicated
     * to. This property is updatable.
     * 
     * @return the targetLocations value.
     */
    public List<TargetRegion> targetLocations() {
        return this.innerProperties() == null ? null : this.innerProperties().targetLocations();
    }

    /**
     * Set the targetLocations property: The target regions where the Resource Profile version is going to be replicated
     * to. This property is updatable.
     * 
     * @param targetLocations the targetLocations value to set.
     * @return the GalleryInVMAccessControlProfileVersionUpdate object itself.
     */
    public GalleryInVMAccessControlProfileVersionUpdate withTargetLocations(List<TargetRegion> targetLocations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryInVMAccessControlProfileVersionProperties();
        }
        this.innerProperties().withTargetLocations(targetLocations);
        return this;
    }

    /**
     * Get the excludeFromLatest property: If set to true, Virtual Machines deployed from the latest version of the
     * Resource Profile won't use this Profile version.
     * 
     * @return the excludeFromLatest value.
     */
    public Boolean excludeFromLatest() {
        return this.innerProperties() == null ? null : this.innerProperties().excludeFromLatest();
    }

    /**
     * Set the excludeFromLatest property: If set to true, Virtual Machines deployed from the latest version of the
     * Resource Profile won't use this Profile version.
     * 
     * @param excludeFromLatest the excludeFromLatest value to set.
     * @return the GalleryInVMAccessControlProfileVersionUpdate object itself.
     */
    public GalleryInVMAccessControlProfileVersionUpdate withExcludeFromLatest(Boolean excludeFromLatest) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryInVMAccessControlProfileVersionProperties();
        }
        this.innerProperties().withExcludeFromLatest(excludeFromLatest);
        return this;
    }

    /**
     * Get the publishedDate property: The timestamp for when the Resource Profile Version is published.
     * 
     * @return the publishedDate value.
     */
    public OffsetDateTime publishedDate() {
        return this.innerProperties() == null ? null : this.innerProperties().publishedDate();
    }

    /**
     * Get the provisioningState property: The provisioning state, which only appears in the response.
     * 
     * @return the provisioningState value.
     */
    public GalleryProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the replicationStatus property: This is the replication status of the gallery image version.
     * 
     * @return the replicationStatus value.
     */
    public ReplicationStatus replicationStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().replicationStatus();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GalleryInVMAccessControlProfileVersionUpdate from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GalleryInVMAccessControlProfileVersionUpdate if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GalleryInVMAccessControlProfileVersionUpdate.
     */
    public static GalleryInVMAccessControlProfileVersionUpdate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryInVMAccessControlProfileVersionUpdate deserializedGalleryInVMAccessControlProfileVersionUpdate
                = new GalleryInVMAccessControlProfileVersionUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileVersionUpdate.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileVersionUpdate.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileVersionUpdate.type = reader.getString();
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedGalleryInVMAccessControlProfileVersionUpdate.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileVersionUpdate.innerProperties
                        = GalleryInVMAccessControlProfileVersionProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGalleryInVMAccessControlProfileVersionUpdate;
        });
    }
}
