// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.GalleryImageVersionInner;
import java.io.IOException;
import java.util.List;

/**
 * The List Gallery Image version operation response.
 */
@Fluent
public final class GalleryImageVersionList implements JsonSerializable<GalleryImageVersionList> {
    /*
     * A list of gallery image versions.
     */
    private List<GalleryImageVersionInner> value;

    /*
     * The uri to fetch the next page of gallery image versions. Call ListNext() with this to fetch the next page of
     * gallery image versions.
     */
    private String nextLink;

    /**
     * Creates an instance of GalleryImageVersionList class.
     */
    public GalleryImageVersionList() {
    }

    /**
     * Get the value property: A list of gallery image versions.
     * 
     * @return the value value.
     */
    public List<GalleryImageVersionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of gallery image versions.
     * 
     * @param value the value value to set.
     * @return the GalleryImageVersionList object itself.
     */
    public GalleryImageVersionList withValue(List<GalleryImageVersionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The uri to fetch the next page of gallery image versions. Call ListNext() with this to
     * fetch the next page of gallery image versions.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The uri to fetch the next page of gallery image versions. Call ListNext() with this to
     * fetch the next page of gallery image versions.
     * 
     * @param nextLink the nextLink value to set.
     * @return the GalleryImageVersionList object itself.
     */
    public GalleryImageVersionList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property value in model GalleryImageVersionList"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GalleryImageVersionList.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GalleryImageVersionList from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GalleryImageVersionList if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GalleryImageVersionList.
     */
    public static GalleryImageVersionList fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryImageVersionList deserializedGalleryImageVersionList = new GalleryImageVersionList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<GalleryImageVersionInner> value
                        = reader.readArray(reader1 -> GalleryImageVersionInner.fromJson(reader1));
                    deserializedGalleryImageVersionList.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedGalleryImageVersionList.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGalleryImageVersionList;
        });
    }
}
