// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.GalleryApplicationInner;
import java.io.IOException;
import java.util.List;

/**
 * The List Gallery Applications operation response.
 */
@Fluent
public final class GalleryApplicationList implements JsonSerializable<GalleryApplicationList> {
    /*
     * The GalleryApplication items on this page
     */
    private List<GalleryApplicationInner> value;

    /*
     * The link to the next page of items
     */
    private String nextLink;

    /**
     * Creates an instance of GalleryApplicationList class.
     */
    public GalleryApplicationList() {
    }

    /**
     * Get the value property: The GalleryApplication items on this page.
     * 
     * @return the value value.
     */
    public List<GalleryApplicationInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The GalleryApplication items on this page.
     * 
     * @param value the value value to set.
     * @return the GalleryApplicationList object itself.
     */
    public GalleryApplicationList withValue(List<GalleryApplicationInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The link to the next page of items.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The link to the next page of items.
     * 
     * @param nextLink the nextLink value to set.
     * @return the GalleryApplicationList object itself.
     */
    public GalleryApplicationList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property value in model GalleryApplicationList"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GalleryApplicationList.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GalleryApplicationList from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GalleryApplicationList if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GalleryApplicationList.
     */
    public static GalleryApplicationList fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryApplicationList deserializedGalleryApplicationList = new GalleryApplicationList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<GalleryApplicationInner> value
                        = reader.readArray(reader1 -> GalleryApplicationInner.fromJson(reader1));
                    deserializedGalleryApplicationList.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedGalleryApplicationList.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGalleryApplicationList;
        });
    }
}
