// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Encryption settings for one disk volume.
 */
@Fluent
public final class EncryptionSettingsElement implements JsonSerializable<EncryptionSettingsElement> {
    /*
     * Key Vault Secret Url and vault id of the disk encryption key
     */
    private KeyVaultAndSecretReference diskEncryptionKey;

    /*
     * Key Vault Key Url and vault id of the key encryption key. KeyEncryptionKey is optional and when provided is used
     * to unwrap the disk encryption key.
     */
    private KeyVaultAndKeyReference keyEncryptionKey;

    /**
     * Creates an instance of EncryptionSettingsElement class.
     */
    public EncryptionSettingsElement() {
    }

    /**
     * Get the diskEncryptionKey property: Key Vault Secret Url and vault id of the disk encryption key.
     * 
     * @return the diskEncryptionKey value.
     */
    public KeyVaultAndSecretReference diskEncryptionKey() {
        return this.diskEncryptionKey;
    }

    /**
     * Set the diskEncryptionKey property: Key Vault Secret Url and vault id of the disk encryption key.
     * 
     * @param diskEncryptionKey the diskEncryptionKey value to set.
     * @return the EncryptionSettingsElement object itself.
     */
    public EncryptionSettingsElement withDiskEncryptionKey(KeyVaultAndSecretReference diskEncryptionKey) {
        this.diskEncryptionKey = diskEncryptionKey;
        return this;
    }

    /**
     * Get the keyEncryptionKey property: Key Vault Key Url and vault id of the key encryption key. KeyEncryptionKey is
     * optional and when provided is used to unwrap the disk encryption key.
     * 
     * @return the keyEncryptionKey value.
     */
    public KeyVaultAndKeyReference keyEncryptionKey() {
        return this.keyEncryptionKey;
    }

    /**
     * Set the keyEncryptionKey property: Key Vault Key Url and vault id of the key encryption key. KeyEncryptionKey is
     * optional and when provided is used to unwrap the disk encryption key.
     * 
     * @param keyEncryptionKey the keyEncryptionKey value to set.
     * @return the EncryptionSettingsElement object itself.
     */
    public EncryptionSettingsElement withKeyEncryptionKey(KeyVaultAndKeyReference keyEncryptionKey) {
        this.keyEncryptionKey = keyEncryptionKey;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (diskEncryptionKey() != null) {
            diskEncryptionKey().validate();
        }
        if (keyEncryptionKey() != null) {
            keyEncryptionKey().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("diskEncryptionKey", this.diskEncryptionKey);
        jsonWriter.writeJsonField("keyEncryptionKey", this.keyEncryptionKey);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EncryptionSettingsElement from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EncryptionSettingsElement if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the EncryptionSettingsElement.
     */
    public static EncryptionSettingsElement fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EncryptionSettingsElement deserializedEncryptionSettingsElement = new EncryptionSettingsElement();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("diskEncryptionKey".equals(fieldName)) {
                    deserializedEncryptionSettingsElement.diskEncryptionKey
                        = KeyVaultAndSecretReference.fromJson(reader);
                } else if ("keyEncryptionKey".equals(fieldName)) {
                    deserializedEncryptionSettingsElement.keyEncryptionKey = KeyVaultAndKeyReference.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEncryptionSettingsElement;
        });
    }
}
