// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Encryption at rest settings for disk or snapshot.
 */
@Fluent
public final class Encryption implements JsonSerializable<Encryption> {
    /*
     * ResourceId of the disk encryption set to use for enabling encryption at rest.
     */
    private String diskEncryptionSetId;

    /*
     * The type of key used to encrypt the data of the disk.
     */
    private EncryptionType type;

    /**
     * Creates an instance of Encryption class.
     */
    public Encryption() {
    }

    /**
     * Get the diskEncryptionSetId property: ResourceId of the disk encryption set to use for enabling encryption at
     * rest.
     * 
     * @return the diskEncryptionSetId value.
     */
    public String diskEncryptionSetId() {
        return this.diskEncryptionSetId;
    }

    /**
     * Set the diskEncryptionSetId property: ResourceId of the disk encryption set to use for enabling encryption at
     * rest.
     * 
     * @param diskEncryptionSetId the diskEncryptionSetId value to set.
     * @return the Encryption object itself.
     */
    public Encryption withDiskEncryptionSetId(String diskEncryptionSetId) {
        this.diskEncryptionSetId = diskEncryptionSetId;
        return this;
    }

    /**
     * Get the type property: The type of key used to encrypt the data of the disk.
     * 
     * @return the type value.
     */
    public EncryptionType type() {
        return this.type;
    }

    /**
     * Set the type property: The type of key used to encrypt the data of the disk.
     * 
     * @param type the type value to set.
     * @return the Encryption object itself.
     */
    public Encryption withType(EncryptionType type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("diskEncryptionSetId", this.diskEncryptionSetId);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Encryption from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Encryption if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the Encryption.
     */
    public static Encryption fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Encryption deserializedEncryption = new Encryption();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("diskEncryptionSetId".equals(fieldName)) {
                    deserializedEncryption.diskEncryptionSetId = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedEncryption.type = EncryptionType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEncryption;
        });
    }
}
