// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Specifies how the virtual machine disk should be created. Possible values are **Attach:** This value is used when you
 * are using a specialized disk to create the virtual machine. **FromImage:** This value is used when you are using an
 * image to create the virtual machine. If you are using a platform image, you should also use the imageReference
 * element described above. If you are using a marketplace image, you should also use the plan element previously
 * described. **Empty:** This value is used when creating an empty data disk. **Copy:** This value is used to create a
 * data disk from a snapshot or another disk. **Restore:** This value is used to create a data disk from a disk restore
 * point.
 */
public final class DiskCreateOptionTypes extends ExpandableStringEnum<DiskCreateOptionTypes> {
    /**
     * Static value FromImage for DiskCreateOptionTypes.
     */
    public static final DiskCreateOptionTypes FROM_IMAGE = fromString("FromImage");

    /**
     * Static value Empty for DiskCreateOptionTypes.
     */
    public static final DiskCreateOptionTypes EMPTY = fromString("Empty");

    /**
     * Static value Attach for DiskCreateOptionTypes.
     */
    public static final DiskCreateOptionTypes ATTACH = fromString("Attach");

    /**
     * Static value Copy for DiskCreateOptionTypes.
     */
    public static final DiskCreateOptionTypes COPY = fromString("Copy");

    /**
     * Static value Restore for DiskCreateOptionTypes.
     */
    public static final DiskCreateOptionTypes RESTORE = fromString("Restore");

    /**
     * Creates a new instance of DiskCreateOptionTypes value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public DiskCreateOptionTypes() {
    }

    /**
     * Creates or finds a DiskCreateOptionTypes from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding DiskCreateOptionTypes.
     */
    public static DiskCreateOptionTypes fromString(String name) {
        return fromString(name, DiskCreateOptionTypes.class);
    }

    /**
     * Gets known DiskCreateOptionTypes values.
     * 
     * @return known DiskCreateOptionTypes values.
     */
    public static Collection<DiskCreateOptionTypes> values() {
        return values(DiskCreateOptionTypes.class);
    }
}
